/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.inspector.eventprocessor;

import io.axoniq.inspector.api.ResetDecision;
import io.axoniq.inspector.api.ResetDecisions;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.config.EventProcessingConfiguration;
import org.axonframework.eventhandling.EventProcessor;
import org.axonframework.eventhandling.StreamingEventProcessor;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.messaging.StreamableMessageSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J#\u0010\u0012\u001a\n \u0007*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/axoniq/inspector/eventprocessor/EventProcessorManager;", "", "eventProcessingConfig", "Lorg/axonframework/config/EventProcessingConfiguration;", "(Lorg/axonframework/config/EventProcessingConfiguration;)V", "mergeSegment", "", "kotlin.jvm.PlatformType", "processorName", "", "segmentId", "", "(Ljava/lang/String;I)Ljava/lang/Boolean;", "releaseSegment", "", "resetTokens", "resetDecision", "Lio/axoniq/inspector/api/ResetDecision;", "splitSegment", "start", "stop", "inspector-axon"})
public final class EventProcessorManager {
    @NotNull
    private final EventProcessingConfiguration eventProcessingConfig;

    public EventProcessorManager(@NotNull EventProcessingConfiguration eventProcessingConfig) {
        Intrinsics.checkNotNullParameter((Object)eventProcessingConfig, (String)"eventProcessingConfig");
        this.eventProcessingConfig = eventProcessingConfig;
    }

    public final void start(@NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        ((EventProcessor)this.eventProcessingConfig.eventProcessor(processorName, EventProcessor.class).orElseThrow(() -> EventProcessorManager.start$lambda$0(processorName))).start();
    }

    public final void stop(@NotNull String processorName) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        ((EventProcessor)this.eventProcessingConfig.eventProcessor(processorName, EventProcessor.class).orElseThrow(() -> EventProcessorManager.stop$lambda$1(processorName))).shutDown();
    }

    public final void releaseSegment(@NotNull String processorName, int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        ((StreamingEventProcessor)this.eventProcessingConfig.eventProcessor(processorName, StreamingEventProcessor.class).orElseThrow(() -> EventProcessorManager.releaseSegment$lambda$2(processorName))).releaseSegment(segmentId);
    }

    public final Boolean splitSegment(@NotNull String processorName, int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return (Boolean)((StreamingEventProcessor)this.eventProcessingConfig.eventProcessor(processorName, StreamingEventProcessor.class).orElseThrow(() -> EventProcessorManager.splitSegment$lambda$3(processorName))).splitSegment(segmentId).get(5L, TimeUnit.SECONDS);
    }

    public final Boolean mergeSegment(@NotNull String processorName, int segmentId) {
        Intrinsics.checkNotNullParameter((Object)processorName, (String)"processorName");
        return (Boolean)((StreamingEventProcessor)this.eventProcessingConfig.eventProcessor(processorName, StreamingEventProcessor.class).orElseThrow(() -> EventProcessorManager.mergeSegment$lambda$4(processorName))).mergeSegment(segmentId).get(5L, TimeUnit.SECONDS);
    }

    public final void resetTokens(@NotNull ResetDecision resetDecision) {
        Intrinsics.checkNotNullParameter((Object)resetDecision, (String)"resetDecision");
        ((StreamingEventProcessor)this.eventProcessingConfig.eventProcessor(resetDecision.getProcessorName(), StreamingEventProcessor.class).orElseThrow(() -> EventProcessorManager.resetTokens$lambda$5(resetDecision))).resetTokens(arg_0 -> EventProcessorManager.resetTokens$lambda$6(resetDecision, arg_0));
    }

    private static final IllegalArgumentException start$lambda$0(String $processorName) {
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        return new IllegalArgumentException("Event Processor [" + $processorName + "] not found!");
    }

    private static final IllegalArgumentException stop$lambda$1(String $processorName) {
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        return new IllegalArgumentException("Event Processor [" + $processorName + "] not found!");
    }

    private static final IllegalArgumentException releaseSegment$lambda$2(String $processorName) {
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        return new IllegalArgumentException("Streaming Event Processor [" + $processorName + "] not found.");
    }

    private static final IllegalArgumentException splitSegment$lambda$3(String $processorName) {
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        return new IllegalArgumentException("Streaming Event Processor [" + $processorName + "] not found.");
    }

    private static final IllegalArgumentException mergeSegment$lambda$4(String $processorName) {
        Intrinsics.checkNotNullParameter((Object)$processorName, (String)"$processorName");
        return new IllegalArgumentException("Streaming Event Processor [" + $processorName + "] not found.");
    }

    private static final IllegalArgumentException resetTokens$lambda$5(ResetDecision $resetDecision) {
        Intrinsics.checkNotNullParameter((Object)$resetDecision, (String)"$resetDecision");
        return new IllegalArgumentException("Streaming Event Processor [" + $resetDecision.getProcessorName() + "] not found.");
    }

    private static final TrackingToken resetTokens$lambda$6(ResetDecision $resetDecision, StreamableMessageSource messageSource) {
        TrackingToken trackingToken;
        Intrinsics.checkNotNullParameter((Object)$resetDecision, (String)"$resetDecision");
        switch (WhenMappings.$EnumSwitchMapping$0[$resetDecision.getDecision().ordinal()]) {
            case 1: {
                trackingToken = messageSource.createHeadToken();
                break;
            }
            case 2: {
                trackingToken = messageSource.createTailToken();
                break;
            }
            case 3: {
                Instant instant = $resetDecision.getFrom();
                Intrinsics.checkNotNull((Object)instant);
                trackingToken = messageSource.createTokenAt(instant);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return trackingToken;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResetDecisions.values().length];
            try {
                nArray[ResetDecisions.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDecisions.TAIL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResetDecisions.FROM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

