/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.inspector.eventprocessor;

import io.axoniq.inspector.api.ProcessorSegmentId;
import io.axoniq.inspector.api.ProcessorStatusReport;
import io.axoniq.inspector.api.ResetDecision;
import io.axoniq.inspector.client.RSocketHandlerRegistrar;
import io.axoniq.inspector.eventprocessor.EventProcessorManager;
import io.axoniq.inspector.eventprocessor.ProcessorReportCreator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.axonframework.lifecycle.Lifecycle;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0006\u0010\u001f\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/axoniq/inspector/eventprocessor/RSocketProcessorResponder;", "Lorg/axonframework/lifecycle/Lifecycle;", "eventProcessorManager", "Lio/axoniq/inspector/eventprocessor/EventProcessorManager;", "processorReportCreator", "Lio/axoniq/inspector/eventprocessor/ProcessorReportCreator;", "registrar", "Lio/axoniq/inspector/client/RSocketHandlerRegistrar;", "(Lio/axoniq/inspector/eventprocessor/EventProcessorManager;Lio/axoniq/inspector/eventprocessor/ProcessorReportCreator;Lio/axoniq/inspector/client/RSocketHandlerRegistrar;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handleMerge", "", "processorSegmentId", "Lio/axoniq/inspector/api/ProcessorSegmentId;", "handleRelease", "", "handleReset", "resetDecision", "Lio/axoniq/inspector/api/ResetDecision;", "handleSplit", "handleStart", "processorName", "", "handleStatusQuery", "Lio/axoniq/inspector/api/ProcessorStatusReport;", "handleStop", "registerLifecycleHandlers", "registry", "Lorg/axonframework/lifecycle/Lifecycle$LifecycleRegistry;", "start", "inspector-axon"})
public class RSocketProcessorResponder
implements Lifecycle {
    @NotNull
    private final EventProcessorManager eventProcessorManager;
    @NotNull
    private final ProcessorReportCreator processorReportCreator;
    @NotNull
    private final RSocketHandlerRegistrar registrar;
    private final Logger logger;

    public RSocketProcessorResponder(@NotNull EventProcessorManager eventProcessorManager, @NotNull ProcessorReportCreator processorReportCreator, @NotNull RSocketHandlerRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)eventProcessorManager, (String)"eventProcessorManager");
        Intrinsics.checkNotNullParameter((Object)processorReportCreator, (String)"processorReportCreator");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        this.eventProcessorManager = eventProcessorManager;
        this.processorReportCreator = processorReportCreator;
        this.registrar = registrar;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void registerLifecycleHandlers(@NotNull Lifecycle.LifecycleRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.onStart(-134217728, this::start);
    }

    public final void start() {
        this.registrar.registerHandlerWithPayload("processor-command-start", String.class, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketProcessorResponder.access$handleStart((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-stop", String.class, (Function1)new Function1<String, Unit>((Object)this){

            public final void invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketProcessorResponder.access$handleStop((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithoutPayload("event-processor-status", (Function0<? extends Object>)((Function0)new Function0<ProcessorStatusReport>((Object)this){

            @NotNull
            public final ProcessorStatusReport invoke() {
                return RSocketProcessorResponder.access$handleStatusQuery((RSocketProcessorResponder)this.receiver);
            }
        }));
        this.registrar.registerHandlerWithPayload("processor-command-release-segment", ProcessorSegmentId.class, (Function1)new Function1<ProcessorSegmentId, Unit>((Object)this){

            public final void invoke(@NotNull ProcessorSegmentId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((RSocketProcessorResponder)this.receiver).handleRelease(p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-split-segment", ProcessorSegmentId.class, (Function1)new Function1<ProcessorSegmentId, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull ProcessorSegmentId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketProcessorResponder.access$handleSplit((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-merge-segment", ProcessorSegmentId.class, (Function1)new Function1<ProcessorSegmentId, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull ProcessorSegmentId p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RSocketProcessorResponder.access$handleMerge((RSocketProcessorResponder)this.receiver, p0);
            }
        });
        this.registrar.registerHandlerWithPayload("processor-command-reset", ResetDecision.class, (Function1)new Function1<ResetDecision, Unit>((Object)this){

            public final void invoke(@NotNull ResetDecision p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                RSocketProcessorResponder.access$handleReset((RSocketProcessorResponder)this.receiver, p0);
            }
        });
    }

    private final void handleStart(String processorName) {
        this.logger.info("Handling Inspector Axon START command for processor [{}]", (Object)processorName);
        this.eventProcessorManager.start(processorName);
    }

    private final void handleStop(String processorName) {
        this.logger.info("Handling Inspector Axon STOP command for processor [{}]", (Object)processorName);
        this.eventProcessorManager.stop(processorName);
    }

    private final ProcessorStatusReport handleStatusQuery() {
        this.logger.info("Handling Inspector Axon STATUS command");
        return this.processorReportCreator.createReport();
    }

    public final void handleRelease(@NotNull ProcessorSegmentId processorSegmentId) {
        Intrinsics.checkNotNullParameter((Object)processorSegmentId, (String)"processorSegmentId");
        this.logger.info("Handling Inspector Axon RELEASE command for processor [{}] and segment [{}]", (Object)processorSegmentId.getProcessorName(), (Object)processorSegmentId.getSegmentId());
        this.eventProcessorManager.releaseSegment(processorSegmentId.getProcessorName(), processorSegmentId.getSegmentId());
    }

    private final boolean handleSplit(ProcessorSegmentId processorSegmentId) {
        this.logger.info("Handling Inspector Axon SPLIT command for processor [{}] and segment [{}]", (Object)processorSegmentId.getProcessorName(), (Object)processorSegmentId.getSegmentId());
        Boolean bl = this.eventProcessorManager.splitSegment(processorSegmentId.getProcessorName(), processorSegmentId.getSegmentId());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"eventProcessorManager\n  \u2026essorSegmentId.segmentId)");
        return bl;
    }

    private final boolean handleMerge(ProcessorSegmentId processorSegmentId) {
        this.logger.info("Handling Inspector Axon MERGE command for processor [{}] and segment [{}]", (Object)processorSegmentId.getProcessorName(), (Object)processorSegmentId.getSegmentId());
        Boolean bl = this.eventProcessorManager.mergeSegment(processorSegmentId.getProcessorName(), processorSegmentId.getSegmentId());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"eventProcessorManager\n  \u2026essorSegmentId.segmentId)");
        return bl;
    }

    private final void handleReset(ResetDecision resetDecision) {
        this.logger.info("Handling Inspector Axon RESET command for processor [{}]", (Object)resetDecision.getProcessorName());
        this.eventProcessorManager.resetTokens(resetDecision);
    }

    public static final /* synthetic */ void access$handleStart(RSocketProcessorResponder $this, String processorName) {
        $this.handleStart(processorName);
    }

    public static final /* synthetic */ void access$handleStop(RSocketProcessorResponder $this, String processorName) {
        $this.handleStop(processorName);
    }

    public static final /* synthetic */ ProcessorStatusReport access$handleStatusQuery(RSocketProcessorResponder $this) {
        return $this.handleStatusQuery();
    }

    public static final /* synthetic */ boolean access$handleSplit(RSocketProcessorResponder $this, ProcessorSegmentId processorSegmentId) {
        return $this.handleSplit(processorSegmentId);
    }

    public static final /* synthetic */ boolean access$handleMerge(RSocketProcessorResponder $this, ProcessorSegmentId processorSegmentId) {
        return $this.handleMerge(processorSegmentId);
    }

    public static final /* synthetic */ void access$handleReset(RSocketProcessorResponder $this, ResetDecision resetDecision) {
        $this.handleReset(resetDecision);
    }
}

