/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.inspector.eventprocessor.metrics;

import io.axoniq.inspector.UtilsKt;
import io.axoniq.inspector.eventprocessor.metrics.ProcessorMetricsRegistry;
import java.time.Clock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0006J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/axoniq/inspector/eventprocessor/metrics/ProcessorMetricsRegistry;", "", "()V", "commitLatencyRegistry", "", "", "", "Lio/axoniq/inspector/eventprocessor/metrics/ProcessorMetricsRegistry$ExpiringLatencyValue;", "ingestLatencyRegistry", "commitLatencyForProcessor", "processor", "segment", "ingestLatencyForProcessor", "registerCommitted", "", "latencyInNanos", "", "registerIngested", "ExpiringLatencyValue", "inspector-axon"})
public final class ProcessorMetricsRegistry {
    @NotNull
    private final Map<String, Map<Integer, ExpiringLatencyValue>> ingestLatencyRegistry = new ConcurrentHashMap();
    @NotNull
    private final Map<String, Map<Integer, ExpiringLatencyValue>> commitLatencyRegistry = new ConcurrentHashMap();

    public final void registerIngested(@NotNull String processor, int segment, long latencyInNanos) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.ingestLatencyForProcessor(processor, segment).setValue((double)latencyInNanos / (double)1000000);
    }

    public final void registerCommitted(@NotNull String processor, int segment, long latencyInNanos) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        this.commitLatencyForProcessor(processor, segment).setValue((double)latencyInNanos / (double)1000000);
    }

    @NotNull
    public final ExpiringLatencyValue ingestLatencyForProcessor(@NotNull String processor, int segment) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return (ExpiringLatencyValue)UtilsKt.computeIfAbsentWithRetry$default((Map)UtilsKt.computeIfAbsentWithRetry$default(this.ingestLatencyRegistry, processor, 0, ingestLatencyForProcessor.1.INSTANCE, 2, null), segment, 0, ingestLatencyForProcessor.2.INSTANCE, 2, null);
    }

    @NotNull
    public final ExpiringLatencyValue commitLatencyForProcessor(@NotNull String processor, int segment) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        return (ExpiringLatencyValue)UtilsKt.computeIfAbsentWithRetry$default((Map)UtilsKt.computeIfAbsentWithRetry$default(this.commitLatencyRegistry, processor, 0, commitLatencyForProcessor.1.INSTANCE, 2, null), segment, 0, commitLatencyForProcessor.2.INSTANCE, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/axoniq/inspector/eventprocessor/metrics/ProcessorMetricsRegistry$ExpiringLatencyValue;", "", "expiryTime", "", "(J)V", "clock", "Ljava/time/Clock;", "kotlin.jvm.PlatformType", "timeSet", "Ljava/util/concurrent/atomic/AtomicLong;", "value", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getValue", "setValue", "", "newValue", "inspector-axon"})
    public static final class ExpiringLatencyValue {
        private final long expiryTime;
        private final Clock clock;
        @NotNull
        private final AtomicReference<Double> value;
        @NotNull
        private final AtomicLong timeSet;

        public ExpiringLatencyValue(long expiryTime) {
            this.expiryTime = expiryTime;
            this.clock = Clock.systemUTC();
            this.value = new AtomicReference<Double>(-1.0);
            this.timeSet = new AtomicLong(-1L);
        }

        public /* synthetic */ ExpiringLatencyValue(long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                l = 30 * 60 * 1000;
            }
            this(l);
        }

        public final void setValue(double newValue) {
            this.value.set(newValue);
            this.timeSet.set(this.clock.millis());
        }

        public final double getValue() {
            if (this.value.get() != null && this.clock.millis() - this.timeSet.get() < this.expiryTime) {
                Double d = this.value.get();
                Intrinsics.checkNotNullExpressionValue((Object)d, (String)"value.get()");
                return ((Number)d).doubleValue();
            }
            return 0.0;
        }

        public ExpiringLatencyValue() {
            this(0L, 1, null);
        }
    }
}

