/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.inspector.messaging;

import io.axoniq.inspector.UtilsKt;
import io.axoniq.inspector.api.metrics.AggregateStatisticIdentifier;
import io.axoniq.inspector.api.metrics.AggregateStatistics;
import io.axoniq.inspector.api.metrics.AggregateStatisticsWithIdentifier;
import io.axoniq.inspector.api.metrics.DispatcherStatisticIdentifier;
import io.axoniq.inspector.api.metrics.DispatcherStatistics;
import io.axoniq.inspector.api.metrics.DispatcherStatisticsWithIdentifier;
import io.axoniq.inspector.api.metrics.HandlerStatistics;
import io.axoniq.inspector.api.metrics.HandlerStatisticsMetricIdentifier;
import io.axoniq.inspector.api.metrics.HandlerStatisticsWithIdentifier;
import io.axoniq.inspector.api.metrics.HandlerType;
import io.axoniq.inspector.api.metrics.Metric;
import io.axoniq.inspector.api.metrics.MetricTargetType;
import io.axoniq.inspector.api.metrics.StatisticDistribution;
import io.axoniq.inspector.api.metrics.StatisticReport;
import io.axoniq.inspector.client.RSocketInspectorClient;
import io.axoniq.inspector.messaging.ExtensionsKt;
import io.axoniq.inspector.messaging.HandlerMetricsRegistry;
import io.axoniq.inspector.messaging.RollingCountMeasure;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.axonframework.lifecycle.Lifecycle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 .2\u00020\u0001:\u0003-./B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\fJ2\u0010$\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020(0*J\u0006\u0010,\u001a\u00020\u001fR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/axoniq/inspector/messaging/HandlerMetricsRegistry;", "Lorg/axonframework/lifecycle/Lifecycle;", "rSocketInspectorClient", "Lio/axoniq/inspector/client/RSocketInspectorClient;", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lio/axoniq/inspector/client/RSocketInspectorClient;Ljava/util/concurrent/ScheduledExecutorService;)V", "aggregates", "", "Lio/axoniq/inspector/api/metrics/AggregateStatisticIdentifier;", "Lio/axoniq/inspector/messaging/HandlerMetricsRegistry$AggregateRegistryStatistics;", "dispatches", "Lio/axoniq/inspector/api/metrics/DispatcherStatisticIdentifier;", "Lio/axoniq/inspector/messaging/RollingCountMeasure;", "handlers", "Lio/axoniq/inspector/api/metrics/HandlerStatisticsMetricIdentifier;", "Lio/axoniq/inspector/messaging/HandlerMetricsRegistry$HandlerRegistryStatistics;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "meterRegistry", "Lio/micrometer/core/instrument/simple/SimpleMeterRegistry;", "createTimer", "Lio/micrometer/core/instrument/Timer;", "handler", "", "name", "", "getStats", "Lio/axoniq/inspector/api/metrics/StatisticReport;", "registerLifecycleHandlers", "", "lifecycle", "Lorg/axonframework/lifecycle/Lifecycle$LifecycleRegistry;", "registerMessageDispatchedDuringHandling", "dispatcher", "registerMessageHandled", "success", "", "duration", "", "metrics", "", "Lio/axoniq/inspector/api/metrics/Metric;", "start", "AggregateRegistryStatistics", "Companion", "HandlerRegistryStatistics", "inspector-axon"})
@SourceDebugExtension(value={"SMAP\nHandlerMetricsRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HandlerMetricsRegistry.kt\nio/axoniq/inspector/messaging/HandlerMetricsRegistry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,190:1\n1547#2:191\n1618#2,2:192\n1620#2:198\n1547#2:199\n1618#2,3:200\n1547#2:203\n1618#2,2:204\n1620#2:210\n125#3:194\n152#3,3:195\n125#3:206\n152#3,3:207\n211#3,2:218\n211#3,2:227\n511#4:211\n496#4,6:212\n511#4:220\n496#4,6:221\n*S KotlinDebug\n*F\n+ 1 HandlerMetricsRegistry.kt\nio/axoniq/inspector/messaging/HandlerMetricsRegistry\n*L\n79#1:191\n79#1:192,2\n79#1:198\n91#1:199\n91#1:200,3\n98#1:203\n98#1:204,2\n98#1:210\n85#1:194\n85#1:195,3\n104#1:206\n104#1:207,3\n132#1:218,2\n149#1:227,2\n131#1:211\n131#1:212,6\n149#1:220\n149#1:221,6\n*E\n"})
public final class HandlerMetricsRegistry
implements Lifecycle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RSocketInspectorClient rSocketInspectorClient;
    @NotNull
    private final ScheduledExecutorService executor;
    private final Logger logger;
    @NotNull
    private final SimpleMeterRegistry meterRegistry;
    @NotNull
    private final Map<DispatcherStatisticIdentifier, RollingCountMeasure> dispatches;
    @NotNull
    private final Map<HandlerStatisticsMetricIdentifier, HandlerRegistryStatistics> handlers;
    @NotNull
    private final Map<AggregateStatisticIdentifier, AggregateRegistryStatistics> aggregates;
    @Nullable
    private static HandlerMetricsRegistry instance;
    private static boolean started;

    public HandlerMetricsRegistry(@NotNull RSocketInspectorClient rSocketInspectorClient, @NotNull ScheduledExecutorService executor) {
        Intrinsics.checkNotNullParameter((Object)rSocketInspectorClient, (String)"rSocketInspectorClient");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.rSocketInspectorClient = rSocketInspectorClient;
        this.executor = executor;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.meterRegistry = new SimpleMeterRegistry();
        this.dispatches = new ConcurrentHashMap();
        this.handlers = new ConcurrentHashMap();
        this.aggregates = new ConcurrentHashMap();
    }

    public void registerLifecycleHandlers(@NotNull Lifecycle.LifecycleRegistry lifecycle) {
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        lifecycle.onStart(0x40000009, this::start);
    }

    public final void start() {
        if (instance != null) {
            this.logger.debug("HandlerMetricRegistry instance already started. Skipping new.");
            return;
        }
        instance = this;
        this.executor.scheduleAtFixedRate(() -> HandlerMetricsRegistry.start$lambda$0(this), 10L, 10L, TimeUnit.SECONDS);
        started = true;
    }

    private final StatisticReport getStats() {
        Collection<AggregateStatisticsWithIdentifier> collection;
        Collection collection2;
        Timer v;
        Metric k;
        Collection<Pair> collection3;
        Map.Entry entry;
        Map.Entry<Object, Object> item$iv$iv;
        Iterator<Map.Entry<Object, Object>> iterator;
        Map<Metric, Timer> $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Map<Metric, Timer> $this$map$iv;
        boolean $i$f$map;
        HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier;
        double d;
        double d2;
        StatisticDistribution statisticDistribution;
        Map.Entry it;
        Collection collection4;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = this.handlers.entrySet();
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            Map.Entry entry2 = (Map.Entry)item$iv$iv2;
            collection4 = destination$iv$iv2;
            boolean bl = false;
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier2 = (HandlerStatisticsMetricIdentifier)it.getKey();
            double d3 = ((HandlerRegistryStatistics)it.getValue()).getTotalCount().count();
            double d4 = ((HandlerRegistryStatistics)it.getValue()).getFailureCount().count();
            HistogramSnapshot histogramSnapshot = ((HandlerRegistryStatistics)it.getValue()).getTotalTimer().takeSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot, (String)"it.value.totalTimer.takeSnapshot()");
            Map<Metric, Timer> map = ((HandlerRegistryStatistics)it.getValue()).getMetrics();
            statisticDistribution = ExtensionsKt.toDistribution(histogramSnapshot);
            d2 = d4;
            d = d3;
            handlerStatisticsMetricIdentifier = handlerStatisticsMetricIdentifier2;
            $i$f$map = false;
            void var19_16 = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = iterator.next();
                collection3 = destination$iv$iv;
                boolean bl2 = false;
                k = (Metric)entry.getKey();
                v = (Timer)entry.getValue();
                String string = k.getFullIdentifier();
                HistogramSnapshot histogramSnapshot2 = v.takeSnapshot();
                Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot2, (String)"v.takeSnapshot()");
                collection3.add(TuplesKt.to((Object)string, (Object)ExtensionsKt.toDistribution(histogramSnapshot2)));
            }
            collection3 = (List)destination$iv$iv;
            Map map2 = MapsKt.toMap((Iterable)collection3);
            StatisticDistribution statisticDistribution2 = statisticDistribution;
            double d5 = d2;
            double d6 = d;
            HandlerStatistics handlerStatistics = new HandlerStatistics(d6, d5, statisticDistribution2, map2);
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier3 = handlerStatisticsMetricIdentifier;
            collection4.add(new HandlerStatisticsWithIdentifier(handlerStatisticsMetricIdentifier3, handlerStatistics));
        }
        $this$map$iv2 = this.dispatches.entrySet();
        collection4 = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            it = (Map.Entry)item$iv$iv2;
            collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add(new DispatcherStatisticsWithIdentifier((DispatcherStatisticIdentifier)it.getKey(), new DispatcherStatistics(((RollingCountMeasure)it.getValue()).count())));
        }
        $this$map$iv2 = this.aggregates.entrySet();
        collection2 = (List)destination$iv$iv2;
        $i$f$map2 = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            it = (Map.Entry)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl = false;
            AggregateStatisticIdentifier aggregateStatisticIdentifier = (AggregateStatisticIdentifier)it.getKey();
            double d7 = ((AggregateRegistryStatistics)it.getValue()).getTotalCount().count();
            double d8 = ((AggregateRegistryStatistics)it.getValue()).getFailureCount().count();
            HistogramSnapshot histogramSnapshot = ((AggregateRegistryStatistics)it.getValue()).getTotalTimer().takeSnapshot();
            Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot, (String)"it.value.totalTimer.takeSnapshot()");
            $this$map$iv = ((AggregateRegistryStatistics)it.getValue()).getMetrics();
            statisticDistribution = ExtensionsKt.toDistribution(histogramSnapshot);
            d2 = d8;
            d = d7;
            handlerStatisticsMetricIdentifier = aggregateStatisticIdentifier;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = item$iv$iv = iterator.next();
                collection3 = destination$iv$iv;
                boolean bl3 = false;
                k = (Metric)entry.getKey();
                v = (Timer)entry.getValue();
                String string = k.getFullIdentifier();
                HistogramSnapshot histogramSnapshot3 = v.takeSnapshot();
                Intrinsics.checkNotNullExpressionValue((Object)histogramSnapshot3, (String)"v.takeSnapshot()");
                collection3.add(TuplesKt.to((Object)string, (Object)ExtensionsKt.toDistribution(histogramSnapshot3)));
            }
            collection3 = (List)destination$iv$iv;
            Map map = MapsKt.toMap((Iterable)collection3);
            StatisticDistribution statisticDistribution3 = statisticDistribution;
            double d9 = d2;
            double d10 = d;
            AggregateStatistics aggregateStatistics = new AggregateStatistics(d10, d9, statisticDistribution3, map);
            HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier4 = handlerStatisticsMetricIdentifier;
            collection.add(new AggregateStatisticsWithIdentifier((AggregateStatisticIdentifier)handlerStatisticsMetricIdentifier4, aggregateStatistics));
        }
        collection = (List)destination$iv$iv2;
        List list = collection;
        Collection collection5 = collection2;
        Collection collection6 = collection4;
        StatisticReport flow = new StatisticReport((List)collection6, (List)collection5, list);
        return flow;
    }

    private final Timer createTimer(Object handler, String name) {
        double[] dArray = new double[]{1.0, 0.95, 0.9, 0.5, 0.01};
        Timer timer = Timer.builder((String)(handler + "_timer_" + name)).publishPercentiles(dArray).distributionStatisticExpiry(Duration.ofMinutes(1L)).distributionStatisticBufferLength(Integer.valueOf(1)).register((MeterRegistry)this.meterRegistry);
        Intrinsics.checkNotNullExpressionValue((Object)timer, (String)"builder(\"${handler}_time\u2026 .register(meterRegistry)");
        return timer;
    }

    /*
     * WARNING - void declaration
     */
    public final void registerMessageHandled(@NotNull HandlerStatisticsMetricIdentifier handler, boolean success, long duration, @NotNull Map<Metric, Long> metrics) {
        void $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        HandlerRegistryStatistics handlerStats2 = (HandlerRegistryStatistics)UtilsKt.computeIfAbsentWithRetry$default(this.handlers, handler, 0, (Function1)new Function1<HandlerStatisticsMetricIdentifier, HandlerRegistryStatistics>(this, handler){
            final /* synthetic */ HandlerMetricsRegistry this$0;
            final /* synthetic */ HandlerStatisticsMetricIdentifier $handler;
            {
                this.this$0 = $receiver;
                this.$handler = $handler;
                super(1);
            }

            @NotNull
            public final HandlerRegistryStatistics invoke(@NotNull HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier) {
                Intrinsics.checkNotNullParameter((Object)handlerStatisticsMetricIdentifier, (String)"<anonymous parameter 0>");
                return new HandlerRegistryStatistics(HandlerMetricsRegistry.access$createTimer(this.this$0, this.$handler, "total"), null, null, null, 14, null);
            }
        }, 2, null);
        handlerStats2.getTotalTimer().record(duration, TimeUnit.NANOSECONDS);
        Map $this$filter$iv = metrics;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo2 = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Metric)it.getKey()).getTargetTypes().contains(MetricTargetType.HANDLER)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $i$f$filterTo2 = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            Metric metric = (Metric)$i$f$filterTo2.getKey();
            long value = ((Number)$i$f$filterTo2.getValue()).longValue();
            ((Timer)UtilsKt.computeIfAbsentWithRetry$default(handlerStats2.getMetrics(), metric, 0, (Function1)new Function1<Metric, Timer>(this, handler, metric){
                final /* synthetic */ HandlerMetricsRegistry this$0;
                final /* synthetic */ HandlerStatisticsMetricIdentifier $handler;
                final /* synthetic */ Metric $metric;
                {
                    this.this$0 = $receiver;
                    this.$handler = $handler;
                    this.$metric = $metric;
                    super(1);
                }

                @NotNull
                public final Timer invoke(@NotNull Metric it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return HandlerMetricsRegistry.access$createTimer(this.this$0, this.$handler, this.$metric.getFullIdentifier());
                }
            }, 2, null)).record(value, metric.getType().getDistributionUnit());
        }
        handlerStats2.getTotalCount().increment();
        if (!success) {
            handlerStats2.getFailureCount().increment();
        }
        if (handler.getType() == HandlerType.Aggregate) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv2;
            String string = handler.getComponent();
            Intrinsics.checkNotNull((Object)string);
            AggregateStatisticIdentifier id = new AggregateStatisticIdentifier(string);
            AggregateRegistryStatistics aggStats2 = (AggregateRegistryStatistics)UtilsKt.computeIfAbsentWithRetry$default(this.aggregates, id, 0, (Function1)new Function1<AggregateStatisticIdentifier, AggregateRegistryStatistics>(this, id){
                final /* synthetic */ HandlerMetricsRegistry this$0;
                final /* synthetic */ AggregateStatisticIdentifier $id;
                {
                    this.this$0 = $receiver;
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final AggregateRegistryStatistics invoke(@NotNull AggregateStatisticIdentifier aggregateStatisticIdentifier) {
                    Intrinsics.checkNotNullParameter((Object)aggregateStatisticIdentifier, (String)"<anonymous parameter 0>");
                    return new AggregateRegistryStatistics(HandlerMetricsRegistry.access$createTimer(this.this$0, this.$id, "total"), null, null, null, 14, null);
                }
            }, 2, null);
            Map $this$filter$iv2 = metrics;
            boolean $i$f$filter2 = false;
            Map $i$f$filterTo2 = $this$filter$iv2;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo3 = false;
            Iterator value = $this$filterTo$iv$iv2.entrySet().iterator();
            while (value.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = value.next();
                boolean bl = false;
                if (!((Metric)it.getKey()).getTargetTypes().contains(MetricTargetType.AGGREGATE)) continue;
                destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv2 = destination$iv$iv2;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl = false;
                Metric metric = (Metric)entry.getKey();
                long value2 = ((Number)entry.getValue()).longValue();
                ((Timer)UtilsKt.computeIfAbsentWithRetry$default(aggStats2.getMetrics(), metric, 0, (Function1)new Function1<Metric, Timer>(this, id, metric){
                    final /* synthetic */ HandlerMetricsRegistry this$0;
                    final /* synthetic */ AggregateStatisticIdentifier $id;
                    final /* synthetic */ Metric $metric;
                    {
                        this.this$0 = $receiver;
                        this.$id = $id;
                        this.$metric = $metric;
                        super(1);
                    }

                    @NotNull
                    public final Timer invoke(@NotNull Metric it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return HandlerMetricsRegistry.access$createTimer(this.this$0, this.$id, this.$metric.getFullIdentifier());
                    }
                }, 2, null)).record(value2, metric.getType().getDistributionUnit());
            }
            aggStats2.getTotalTimer().record(duration, TimeUnit.NANOSECONDS);
            aggStats2.getTotalCount().increment();
            if (!success) {
                aggStats2.getFailureCount().increment();
            }
        }
    }

    public final void registerMessageDispatchedDuringHandling(@NotNull DispatcherStatisticIdentifier dispatcher) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        ((RollingCountMeasure)UtilsKt.computeIfAbsentWithRetry$default(this.dispatches, dispatcher, 0, registerMessageDispatchedDuringHandling.1.INSTANCE, 2, null)).increment();
    }

    private static final void start$lambda$0(HandlerMetricsRegistry this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            StatisticReport stats = this$0.getStats();
            this$0.logger.debug("Sending metrics: {}", (Object)stats);
            this$0.rSocketInspectorClient.send("message-flow-stats", stats).block();
        }
        catch (Exception e) {
            this$0.logger.warn("No metrics could be reported to Inspector Axon: {}", (Object)e.getMessage());
        }
    }

    public static final /* synthetic */ Timer access$createTimer(HandlerMetricsRegistry $this, Object handler, String name) {
        return $this.createTimer(handler, name);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/axoniq/inspector/messaging/HandlerMetricsRegistry$AggregateRegistryStatistics;", "", "totalTimer", "Lio/micrometer/core/instrument/Timer;", "totalCount", "Lio/axoniq/inspector/messaging/RollingCountMeasure;", "failureCount", "metrics", "", "Lio/axoniq/inspector/api/metrics/Metric;", "(Lio/micrometer/core/instrument/Timer;Lio/axoniq/inspector/messaging/RollingCountMeasure;Lio/axoniq/inspector/messaging/RollingCountMeasure;Ljava/util/Map;)V", "getFailureCount", "()Lio/axoniq/inspector/messaging/RollingCountMeasure;", "getMetrics", "()Ljava/util/Map;", "getTotalCount", "getTotalTimer", "()Lio/micrometer/core/instrument/Timer;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "inspector-axon"})
    private static final class AggregateRegistryStatistics {
        @NotNull
        private final Timer totalTimer;
        @NotNull
        private final RollingCountMeasure totalCount;
        @NotNull
        private final RollingCountMeasure failureCount;
        @NotNull
        private final Map<Metric, Timer> metrics;

        public AggregateRegistryStatistics(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            this.totalTimer = totalTimer;
            this.totalCount = totalCount;
            this.failureCount = failureCount;
            this.metrics = metrics;
        }

        public /* synthetic */ AggregateRegistryStatistics(Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                rollingCountMeasure = new RollingCountMeasure();
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = new RollingCountMeasure();
            }
            if ((n & 8) != 0) {
                map = new ConcurrentHashMap();
            }
            this(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public final Timer getTotalTimer() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure getFailureCount() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> getMetrics() {
            return this.metrics;
        }

        @NotNull
        public final Timer component1() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure component2() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure component3() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> component4() {
            return this.metrics;
        }

        @NotNull
        public final AggregateRegistryStatistics copy(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            return new AggregateRegistryStatistics(totalTimer, totalCount, failureCount, metrics);
        }

        public static /* synthetic */ AggregateRegistryStatistics copy$default(AggregateRegistryStatistics aggregateRegistryStatistics, Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                timer = aggregateRegistryStatistics.totalTimer;
            }
            if ((n & 2) != 0) {
                rollingCountMeasure = aggregateRegistryStatistics.totalCount;
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = aggregateRegistryStatistics.failureCount;
            }
            if ((n & 8) != 0) {
                map = aggregateRegistryStatistics.metrics;
            }
            return aggregateRegistryStatistics.copy(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public String toString() {
            return "AggregateRegistryStatistics(totalTimer=" + this.totalTimer + ", totalCount=" + this.totalCount + ", failureCount=" + this.failureCount + ", metrics=" + this.metrics + ')';
        }

        public int hashCode() {
            int result = this.totalTimer.hashCode();
            result = result * 31 + this.totalCount.hashCode();
            result = result * 31 + this.failureCount.hashCode();
            result = result * 31 + ((Object)this.metrics).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AggregateRegistryStatistics)) {
                return false;
            }
            AggregateRegistryStatistics aggregateRegistryStatistics = (AggregateRegistryStatistics)other;
            if (!Intrinsics.areEqual((Object)this.totalTimer, (Object)aggregateRegistryStatistics.totalTimer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.totalCount, (Object)aggregateRegistryStatistics.totalCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.failureCount, (Object)aggregateRegistryStatistics.failureCount)) {
                return false;
            }
            return Intrinsics.areEqual(this.metrics, aggregateRegistryStatistics.metrics);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/axoniq/inspector/messaging/HandlerMetricsRegistry$Companion;", "", "()V", "instance", "Lio/axoniq/inspector/messaging/HandlerMetricsRegistry;", "started", "", "getInstance", "inspector-axon"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HandlerMetricsRegistry getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lio/axoniq/inspector/messaging/HandlerMetricsRegistry$HandlerRegistryStatistics;", "", "totalTimer", "Lio/micrometer/core/instrument/Timer;", "totalCount", "Lio/axoniq/inspector/messaging/RollingCountMeasure;", "failureCount", "metrics", "", "Lio/axoniq/inspector/api/metrics/Metric;", "(Lio/micrometer/core/instrument/Timer;Lio/axoniq/inspector/messaging/RollingCountMeasure;Lio/axoniq/inspector/messaging/RollingCountMeasure;Ljava/util/Map;)V", "getFailureCount", "()Lio/axoniq/inspector/messaging/RollingCountMeasure;", "getMetrics", "()Ljava/util/Map;", "getTotalCount", "getTotalTimer", "()Lio/micrometer/core/instrument/Timer;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "inspector-axon"})
    private static final class HandlerRegistryStatistics {
        @NotNull
        private final Timer totalTimer;
        @NotNull
        private final RollingCountMeasure totalCount;
        @NotNull
        private final RollingCountMeasure failureCount;
        @NotNull
        private final Map<Metric, Timer> metrics;

        public HandlerRegistryStatistics(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            this.totalTimer = totalTimer;
            this.totalCount = totalCount;
            this.failureCount = failureCount;
            this.metrics = metrics;
        }

        public /* synthetic */ HandlerRegistryStatistics(Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                rollingCountMeasure = new RollingCountMeasure();
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = new RollingCountMeasure();
            }
            if ((n & 8) != 0) {
                map = new ConcurrentHashMap();
            }
            this(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public final Timer getTotalTimer() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure getTotalCount() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure getFailureCount() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> getMetrics() {
            return this.metrics;
        }

        @NotNull
        public final Timer component1() {
            return this.totalTimer;
        }

        @NotNull
        public final RollingCountMeasure component2() {
            return this.totalCount;
        }

        @NotNull
        public final RollingCountMeasure component3() {
            return this.failureCount;
        }

        @NotNull
        public final Map<Metric, Timer> component4() {
            return this.metrics;
        }

        @NotNull
        public final HandlerRegistryStatistics copy(@NotNull Timer totalTimer, @NotNull RollingCountMeasure totalCount, @NotNull RollingCountMeasure failureCount, @NotNull Map<Metric, Timer> metrics) {
            Intrinsics.checkNotNullParameter((Object)totalTimer, (String)"totalTimer");
            Intrinsics.checkNotNullParameter((Object)totalCount, (String)"totalCount");
            Intrinsics.checkNotNullParameter((Object)failureCount, (String)"failureCount");
            Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
            return new HandlerRegistryStatistics(totalTimer, totalCount, failureCount, metrics);
        }

        public static /* synthetic */ HandlerRegistryStatistics copy$default(HandlerRegistryStatistics handlerRegistryStatistics, Timer timer, RollingCountMeasure rollingCountMeasure, RollingCountMeasure rollingCountMeasure2, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                timer = handlerRegistryStatistics.totalTimer;
            }
            if ((n & 2) != 0) {
                rollingCountMeasure = handlerRegistryStatistics.totalCount;
            }
            if ((n & 4) != 0) {
                rollingCountMeasure2 = handlerRegistryStatistics.failureCount;
            }
            if ((n & 8) != 0) {
                map = handlerRegistryStatistics.metrics;
            }
            return handlerRegistryStatistics.copy(timer, rollingCountMeasure, rollingCountMeasure2, map);
        }

        @NotNull
        public String toString() {
            return "HandlerRegistryStatistics(totalTimer=" + this.totalTimer + ", totalCount=" + this.totalCount + ", failureCount=" + this.failureCount + ", metrics=" + this.metrics + ')';
        }

        public int hashCode() {
            int result = this.totalTimer.hashCode();
            result = result * 31 + this.totalCount.hashCode();
            result = result * 31 + this.failureCount.hashCode();
            result = result * 31 + ((Object)this.metrics).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HandlerRegistryStatistics)) {
                return false;
            }
            HandlerRegistryStatistics handlerRegistryStatistics = (HandlerRegistryStatistics)other;
            if (!Intrinsics.areEqual((Object)this.totalTimer, (Object)handlerRegistryStatistics.totalTimer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.totalCount, (Object)handlerRegistryStatistics.totalCount)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.failureCount, (Object)handlerRegistryStatistics.failureCount)) {
                return false;
            }
            return Intrinsics.areEqual(this.metrics, handlerRegistryStatistics.metrics);
        }
    }
}

