/*
 * Decompiled with CFR 0.152.
 */
package io.axoniq.inspector.messaging;

import io.axoniq.inspector.UtilsKt;
import io.axoniq.inspector.api.metrics.DispatcherStatisticIdentifier;
import io.axoniq.inspector.api.metrics.HandlerStatisticsMetricIdentifier;
import io.axoniq.inspector.api.metrics.MessageIdentifier;
import io.axoniq.inspector.api.metrics.Metric;
import io.axoniq.inspector.api.metrics.MetricType;
import io.axoniq.inspector.api.metrics.PreconfiguredMetric;
import io.axoniq.inspector.messaging.HandlerMetricsRegistry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanAttributesProvider;
import org.axonframework.tracing.SpanFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0004\u001d\u001e\u001f B\u0005\u00a2\u0006\u0002\u0010\u0002JI\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u001e\u0010\n\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\u000b\"\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\fJO\u0010\r\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u001e\u0010\u0010\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\t0\u000b\"\b\u0012\u0002\b\u0003\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\"\u0010\u0012\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\tH\u0016J\u0016\u0010\u0014\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J%\u0010\u0015\u001a\u0002H\u0016\"\u000e\b\u0000\u0010\u0016*\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0013\u001a\u0002H\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0014\u0010\u001c\u001a\u00020\u00042\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\tH\u0002\u00a8\u0006!"}, d2={"Lio/axoniq/inspector/messaging/InspectorSpanFactory;", "Lorg/axonframework/tracing/SpanFactory;", "()V", "createDispatchSpan", "Lorg/axonframework/tracing/Span;", "operationNameSupplier", "Ljava/util/function/Supplier;", "", "parentMessage", "Lorg/axonframework/messaging/Message;", "linkedSiblings", "", "(Ljava/util/function/Supplier;Lorg/axonframework/messaging/Message;[Lorg/axonframework/messaging/Message;)Lorg/axonframework/tracing/Span;", "createHandlerSpan", "isChildTrace", "", "linkedParents", "(Ljava/util/function/Supplier;Lorg/axonframework/messaging/Message;Z[Lorg/axonframework/messaging/Message;)Lorg/axonframework/tracing/Span;", "createInternalSpan", "message", "createRootTrace", "propagateContext", "M", "(Lorg/axonframework/messaging/Message;)Lorg/axonframework/messaging/Message;", "registerSpanAttributeProvider", "", "provider", "Lorg/axonframework/tracing/SpanAttributesProvider;", "startIfNotActive", "Companion", "MeasuringInspectorSpan", "NoopSpan", "TimeRecordingSpan", "inspector-axon"})
public final class InspectorSpanFactory
implements SpanFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger logger = LoggerFactory.getLogger(Companion.getClass());
    @NotNull
    private static final NoopSpan NOOP_SPAN = new NoopSpan();
    @NotNull
    private static final ConcurrentHashMap<String, MeasuringInspectorSpan> ACTIVE_ROOT_SPANS = new ConcurrentHashMap();
    @NotNull
    private static final ThreadLocal<String> CURRENT_MESSAGE_ID = new ThreadLocal();

    @NotNull
    public Span createRootTrace(@NotNull Supplier<String> operationNameSupplier) {
        Intrinsics.checkNotNullParameter(operationNameSupplier, (String)"operationNameSupplier");
        return NOOP_SPAN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public Span createHandlerSpan(@NotNull Supplier<String> operationNameSupplier, @NotNull Message<?> parentMessage, boolean isChildTrace, Message<?> ... linkedParents) {
        Intrinsics.checkNotNullParameter(operationNameSupplier, (String)"operationNameSupplier");
        Intrinsics.checkNotNullParameter(parentMessage, (String)"parentMessage");
        Intrinsics.checkNotNullParameter(linkedParents, (String)"linkedParents");
        String string = operationNameSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"operationNameSupplier.get()");
        String name = string;
        switch (name.hashCode()) {
            case 74159272: {
                if (name.equals("AxonServerCommandBus.handle")) return this.startIfNotActive(parentMessage);
                return NOOP_SPAN;
            }
            case 34129068: {
                if (name.equals("DeadlineJob.execute")) return this.startIfNotActive(parentMessage);
                return NOOP_SPAN;
            }
            case 2016986624: {
                if (!name.equals("QueryProcessingTask")) return NOOP_SPAN;
                return this.startIfNotActive(parentMessage);
            }
        }
        return NOOP_SPAN;
    }

    @NotNull
    public Span createDispatchSpan(@NotNull Supplier<String> operationNameSupplier, @Nullable Message<?> parentMessage, Message<?> ... linkedSiblings) {
        Intrinsics.checkNotNullParameter(operationNameSupplier, (String)"operationNameSupplier");
        Intrinsics.checkNotNullParameter(linkedSiblings, (String)"linkedSiblings");
        return NOOP_SPAN;
    }

    @NotNull
    public Span createInternalSpan(@NotNull Supplier<String> operationNameSupplier) {
        Intrinsics.checkNotNullParameter(operationNameSupplier, (String)"operationNameSupplier");
        String string = operationNameSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"operationNameSupplier.get()");
        String name = string;
        if (Intrinsics.areEqual((Object)name, (Object)"LockingRepository.obtainLock")) {
            return new TimeRecordingSpan((Metric)PreconfiguredMetric.AGGREGATE_LOCK_TIME);
        }
        if (StringsKt.contains$default((CharSequence)name, (CharSequence)".load ", (boolean)false, (int)2, null)) {
            return new TimeRecordingSpan((Metric)PreconfiguredMetric.AGGREGATE_LOAD_TIME);
        }
        if (StringsKt.endsWith$default((String)name, (String)".commit", (boolean)false, (int)2, null)) {
            return new TimeRecordingSpan((Metric)PreconfiguredMetric.EVENT_COMMIT_TIME);
        }
        return NOOP_SPAN;
    }

    @NotNull
    public Span createInternalSpan(@NotNull Supplier<String> operationNameSupplier, @NotNull Message<?> message) {
        Intrinsics.checkNotNullParameter(operationNameSupplier, (String)"operationNameSupplier");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        String string = operationNameSupplier.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"operationNameSupplier.get()");
        String name = string;
        if (StringsKt.endsWith$default((String)name, (String)"Bus.handle", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)name, (Object)"SimpleQueryBus.query") || StringsKt.startsWith$default((String)name, (String)"SimpleQueryBus.scatterGather", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"PooledStreamingEventProcessor", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"TrackingEventProcessor", (boolean)false, (int)2, null)) {
            return this.startIfNotActive(message);
        }
        return NOOP_SPAN;
    }

    public void registerSpanAttributeProvider(@Nullable SpanAttributesProvider provider) {
    }

    public <M extends Message<?>> M propagateContext(M message) {
        return message;
    }

    private final Span startIfNotActive(Message<?> message) {
        if (ACTIVE_ROOT_SPANS.containsKey(message.getIdentifier())) {
            return NOOP_SPAN;
        }
        Map map = ACTIVE_ROOT_SPANS;
        String string = message.getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.identifier");
        return (Span)UtilsKt.computeIfAbsentWithRetry$default(map, string, 0, (Function1)new Function1<String, MeasuringInspectorSpan>(this, message){
            final /* synthetic */ InspectorSpanFactory this$0;
            final /* synthetic */ Message<?> $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            @NotNull
            public final MeasuringInspectorSpan invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = this.$message.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.identifier");
                return this.this$0.new MeasuringInspectorSpan(string);
            }
        }, 2, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000f\u001a\u00020\u00102\u0016\u0010\u0011\u001a\u0012\u0012\b\u0012\u00060\u0006R\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u0012R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/axoniq/inspector/messaging/InspectorSpanFactory$Companion;", "", "()V", "ACTIVE_ROOT_SPANS", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lio/axoniq/inspector/messaging/InspectorSpanFactory$MeasuringInspectorSpan;", "Lio/axoniq/inspector/messaging/InspectorSpanFactory;", "CURRENT_MESSAGE_ID", "Ljava/lang/ThreadLocal;", "NOOP_SPAN", "Lio/axoniq/inspector/messaging/InspectorSpanFactory$NoopSpan;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "onTopLevelSpanIfActive", "", "block", "Lkotlin/Function1;", "inspector-axon"})
    public static final class Companion {
        private Companion() {
        }

        public final void onTopLevelSpanIfActive(@NotNull Function1<? super MeasuringInspectorSpan, Unit> block) {
            block3: {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                if (CURRENT_MESSAGE_ID.get() == null) {
                    return;
                }
                MeasuringInspectorSpan measuringInspectorSpan = (MeasuringInspectorSpan)ACTIVE_ROOT_SPANS.get(CURRENT_MESSAGE_ID.get());
                if (measuringInspectorSpan == null) break block3;
                MeasuringInspectorSpan it = measuringInspectorSpan;
                boolean bl = false;
                try {
                    block.invoke((Object)it);
                }
                catch (Exception e) {
                    logger.info("Was unable to report Inspector Axon metrics", (Throwable)e);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\n\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00142\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0007J\u0016\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000fJ\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010 \u001a\u00020\u0001H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/axoniq/inspector/messaging/InspectorSpanFactory$MeasuringInspectorSpan;", "Lorg/axonframework/tracing/Span;", "messageId", "", "(Lio/axoniq/inspector/messaging/InspectorSpanFactory;Ljava/lang/String;)V", "dispatchedMessages", "", "Lio/axoniq/inspector/api/metrics/MessageIdentifier;", "handlerMetricIdentifier", "Lio/axoniq/inspector/api/metrics/HandlerStatisticsMetricIdentifier;", "handlerSuccessful", "", "metrics", "", "Lio/axoniq/inspector/api/metrics/Metric;", "", "timeStarted", "Ljava/lang/Long;", "transactionSuccessful", "end", "", "recordException", "t", "", "registerHandler", "time", "registerMessageDispatched", "message", "registerMetricValue", "metric", "value", "report", "start", "inspector-axon"})
    @SourceDebugExtension(value={"SMAP\nInspectorSpanFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InspectorSpanFactory.kt\nio/axoniq/inspector/messaging/InspectorSpanFactory$MeasuringInspectorSpan\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,241:1\n1#2:242\n1849#3,2:243\n*S KotlinDebug\n*F\n+ 1 InspectorSpanFactory.kt\nio/axoniq/inspector/messaging/InspectorSpanFactory$MeasuringInspectorSpan\n*L\n119#1:243,2\n*E\n"})
    public final class MeasuringInspectorSpan
    implements Span {
        @NotNull
        private final String messageId;
        @Nullable
        private Long timeStarted;
        private boolean transactionSuccessful;
        @Nullable
        private HandlerStatisticsMetricIdentifier handlerMetricIdentifier;
        private boolean handlerSuccessful;
        @NotNull
        private List<MessageIdentifier> dispatchedMessages;
        @NotNull
        private final Map<Metric, Long> metrics;

        public MeasuringInspectorSpan(String messageId) {
            Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
            this.messageId = messageId;
            this.transactionSuccessful = true;
            this.handlerSuccessful = true;
            this.dispatchedMessages = new ArrayList();
            this.metrics = new LinkedHashMap();
        }

        public final void registerHandler(@Nullable HandlerStatisticsMetricIdentifier handlerMetricIdentifier, long time) {
            if (handlerMetricIdentifier == null) {
                return;
            }
            this.handlerMetricIdentifier = handlerMetricIdentifier;
            this.registerMetricValue((Metric)PreconfiguredMetric.MESSAGE_HANDLER_TIME, time);
        }

        public final void registerMessageDispatched(@NotNull MessageIdentifier message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.dispatchedMessages.add(message);
        }

        /*
         * WARNING - void declaration
         */
        public final void registerMetricValue(@NotNull Metric metric, long value) {
            long l;
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            Iterable iterable = metric.getBreakDownMetrics();
            long l2 = value;
            long l3 = 0L;
            for (Object t : iterable) {
                void it;
                Metric metric2 = (Metric)t;
                l = l3;
                boolean bl = false;
                Long l4 = this.metrics.get(it);
                long l5 = l4 != null ? l4 : 0L;
                l3 = l + l5;
            }
            l = l3;
            long actualValue = l2 - l;
            Long l6 = actualValue;
            this.metrics.put(metric, l6);
        }

        @NotNull
        public Span start() {
            logger.trace("Starting span for message id " + this.messageId);
            ((Map)ACTIVE_ROOT_SPANS).put(this.messageId, this);
            CURRENT_MESSAGE_ID.set(this.messageId);
            this.timeStarted = System.nanoTime();
            CurrentUnitOfWork.map(arg_0 -> MeasuringInspectorSpan.start$lambda$1(this, arg_0));
            return this;
        }

        public void end() {
            long end2 = System.nanoTime();
            ACTIVE_ROOT_SPANS.remove(this.messageId);
            CURRENT_MESSAGE_ID.remove();
            logger.trace("Ending span for message id " + this.messageId + "  = " + this.handlerMetricIdentifier);
            if (this.handlerMetricIdentifier == null || this.timeStarted == null) {
                return;
            }
            CurrentUnitOfWork.map(arg_0 -> MeasuringInspectorSpan.end$lambda$2(this, end2, arg_0)).orElseGet(() -> MeasuringInspectorSpan.end$lambda$3(this, end2));
        }

        private final void report(long end2) {
            block4: {
                try {
                    logger.trace("Reporting span for message id " + this.messageId + " = " + this.handlerMetricIdentifier);
                    boolean success = this.handlerSuccessful && this.transactionSuccessful;
                    HandlerMetricsRegistry handlerMetricsRegistry = HandlerMetricsRegistry.Companion.getInstance();
                    if (handlerMetricsRegistry != null) {
                        HandlerStatisticsMetricIdentifier handlerStatisticsMetricIdentifier = this.handlerMetricIdentifier;
                        Intrinsics.checkNotNull((Object)handlerStatisticsMetricIdentifier);
                        Long l = this.timeStarted;
                        Intrinsics.checkNotNull((Object)l);
                        handlerMetricsRegistry.registerMessageHandled(handlerStatisticsMetricIdentifier, success, end2 - l, this.metrics);
                    }
                    if (!success) break block4;
                    Iterable $this$forEach$iv = this.dispatchedMessages;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        MessageIdentifier it = (MessageIdentifier)element$iv;
                        boolean bl = false;
                        HandlerMetricsRegistry handlerMetricsRegistry2 = HandlerMetricsRegistry.Companion.getInstance();
                        if (handlerMetricsRegistry2 == null) continue;
                        handlerMetricsRegistry2.registerMessageDispatchedDuringHandling(new DispatcherStatisticIdentifier(this.handlerMetricIdentifier, it));
                    }
                }
                catch (Exception e) {
                    logger.info("Could not report metrics for message " + this.handlerMetricIdentifier, (Throwable)e);
                }
            }
        }

        @NotNull
        public Span recordException(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            this.transactionSuccessful = false;
            return this;
        }

        private static final Unit start$lambda$1(MeasuringInspectorSpan this$0, UnitOfWork it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            it.onRollback(new Consumer(this$0){
                final /* synthetic */ MeasuringInspectorSpan this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(UnitOfWork<? extends Message<?>> it) {
                    MeasuringInspectorSpan.access$setTransactionSuccessful$p(this.this$0, false);
                }
            });
            return Unit.INSTANCE;
        }

        private static final Unit end$lambda$2(MeasuringInspectorSpan this$0, long $end, UnitOfWork it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            it.onCleanup(new Consumer(this$0, $end){
                final /* synthetic */ MeasuringInspectorSpan this$0;
                final /* synthetic */ long $end;
                {
                    this.this$0 = $receiver;
                    this.$end = $end;
                }

                public final void accept(UnitOfWork<? extends Message<?>> it) {
                    MeasuringInspectorSpan.access$report(this.this$0, this.$end);
                }
            });
            return Unit.INSTANCE;
        }

        private static final Unit end$lambda$3(MeasuringInspectorSpan this$0, long $end) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.report($end);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$setTransactionSuccessful$p(MeasuringInspectorSpan $this, boolean bl) {
            $this.transactionSuccessful = bl;
        }

        public static final /* synthetic */ void access$report(MeasuringInspectorSpan $this, long end2) {
            $this.report(end2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\b\u001a\u00020\u0001H\u0016\u00a8\u0006\t"}, d2={"Lio/axoniq/inspector/messaging/InspectorSpanFactory$NoopSpan;", "Lorg/axonframework/tracing/Span;", "()V", "end", "", "recordException", "t", "", "start", "inspector-axon"})
    public static final class NoopSpan
    implements Span {
        @NotNull
        public Span start() {
            return this;
        }

        public void end() {
        }

        @NotNull
        public Span recordException(@Nullable Throwable t) {
            return this;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\b\u0010\r\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lio/axoniq/inspector/messaging/InspectorSpanFactory$TimeRecordingSpan;", "Lorg/axonframework/tracing/Span;", "metric", "Lio/axoniq/inspector/api/metrics/Metric;", "(Lio/axoniq/inspector/api/metrics/Metric;)V", "started", "", "Ljava/lang/Long;", "end", "", "recordException", "t", "", "start", "inspector-axon"})
    public static final class TimeRecordingSpan
    implements Span {
        @NotNull
        private final Metric metric;
        @Nullable
        private Long started;

        public TimeRecordingSpan(@NotNull Metric metric) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
            this.metric = metric;
            boolean bl2 = bl = this.metric.getType() == MetricType.TIMER;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }

        @NotNull
        public Span start() {
            this.started = System.nanoTime();
            return this;
        }

        public void end() {
            if (this.started == null) {
                return;
            }
            long ended = System.nanoTime();
            Companion.onTopLevelSpanIfActive((Function1<? super MeasuringInspectorSpan, Unit>)((Function1)new Function1<MeasuringInspectorSpan, Unit>(this, ended){
                final /* synthetic */ TimeRecordingSpan this$0;
                final /* synthetic */ long $ended;
                {
                    this.this$0 = $receiver;
                    this.$ended = $ended;
                    super(1);
                }

                public final void invoke(@NotNull MeasuringInspectorSpan it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    Metric metric = TimeRecordingSpan.access$getMetric$p(this.this$0);
                    Long l = TimeRecordingSpan.access$getStarted$p(this.this$0);
                    Intrinsics.checkNotNull((Object)l);
                    it.registerMetricValue(metric, this.$ended - l);
                }
            }));
        }

        @NotNull
        public Span recordException(@Nullable Throwable t) {
            return this;
        }

        public static final /* synthetic */ Metric access$getMetric$p(TimeRecordingSpan $this) {
            return $this.metric;
        }

        public static final /* synthetic */ Long access$getStarted$p(TimeRecordingSpan $this) {
            return $this.started;
        }
    }
}

