/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth;

import io.ballerina.messaging.broker.auth.BrokerAuthConfiguration;
import io.ballerina.messaging.broker.auth.authentication.Authenticator;
import io.ballerina.messaging.broker.auth.authentication.AuthenticatorFactory;
import io.ballerina.messaging.broker.auth.authentication.sasl.BrokerSecurityProvider;
import io.ballerina.messaging.broker.auth.authentication.sasl.SaslServerBuilder;
import io.ballerina.messaging.broker.auth.authentication.sasl.plain.PlainSaslServerBuilder;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.AuthorizerFactory;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.ValidationException;
import io.ballerina.messaging.broker.common.config.BrokerCommonConfiguration;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthManager.class);
    private static final String AMQP_PROTOCOL_IDENTIFIER = "AMQP";
    private static final String PROVIDER_NAME = "AMQSASLProvider";
    private Map<String, SaslServerBuilder> saslMechanisms = new HashMap<String, SaslServerBuilder>();
    private Authenticator authenticator;
    private Authorizer authorizer;
    private final boolean isAuthenticationEnabled;
    private final boolean isAuthorizationEnabled;

    public AuthManager(StartupContext startupContext) throws Exception {
        BrokerConfigProvider configProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        BrokerAuthConfiguration brokerAuthConfiguration = (BrokerAuthConfiguration)configProvider.getConfigurationObject("ballerina.broker.auth", BrokerAuthConfiguration.class);
        this.isAuthenticationEnabled = brokerAuthConfiguration.getAuthentication().isEnabled();
        this.isAuthorizationEnabled = brokerAuthConfiguration.getAuthorization().isEnabled();
        if (this.isAuthenticationEnabled) {
            UserStore userStore = AuthorizerFactory.createUserStore(startupContext, brokerAuthConfiguration);
            this.authenticator = new AuthenticatorFactory().getAuthenticator(startupContext, brokerAuthConfiguration.getAuthentication(), userStore);
            BrokerCommonConfiguration commonConfigs = (BrokerCommonConfiguration)configProvider.getConfigurationObject("ballerina.broker", BrokerCommonConfiguration.class);
            if (this.isAuthorizationEnabled) {
                this.authorizer = AuthorizerFactory.getAuthorizer(commonConfigs, brokerAuthConfiguration, userStore, startupContext);
            }
        } else if (this.isAuthorizationEnabled) {
            throw new ValidationException("Invalid combination found in the configuration - authentication enabled: FALSE and authorization enabled: TRUE");
        }
        startupContext.registerService(AuthManager.class, (Object)this);
    }

    public void start() {
        if (this.isAuthenticationEnabled()) {
            this.registerSaslServers();
        }
    }

    public void stop() {
        LOGGER.info("Broker auth manager service stopped.");
    }

    private void registerSaslServers() {
        PlainSaslServerBuilder plainSaslServerBuilder = new PlainSaslServerBuilder(this.authenticator);
        this.saslMechanisms.put(plainSaslServerBuilder.getMechanismName(), plainSaslServerBuilder);
        if (Security.insertProviderAt(new BrokerSecurityProvider(PROVIDER_NAME, this.saslMechanisms), 1) == -1) {
            LOGGER.info("AMQ security authentication providers are already installed.");
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("AMQ security authentication mechanisms providers are successfully registered.");
        }
    }

    public SaslServer createSaslServer(String hostName, String mechanism) throws SaslException {
        SaslServerBuilder saslServerBuilder = this.saslMechanisms.get(mechanism);
        if (saslServerBuilder != null) {
            SaslServer saslServer = Sasl.createSaslServer(mechanism, AMQP_PROTOCOL_IDENTIFIER, hostName, saslServerBuilder.getProperties(), saslServerBuilder.getCallbackHandler());
            if (saslServer != null) {
                return saslServer;
            }
            throw new SaslException("Sasl server cannot be found for mechanism: " + mechanism);
        }
        throw new SaslException("Server does not support for mechanism: " + mechanism);
    }

    public boolean isAuthenticationEnabled() {
        return this.isAuthenticationEnabled;
    }

    public boolean isAuthorizationEnabled() {
        return this.isAuthorizationEnabled;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }
}

