/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth;

import io.ballerina.messaging.broker.auth.authentication.authenticator.DefaultAuthenticator;
import io.ballerina.messaging.broker.auth.authorization.provider.FileBasedUserStore;
import io.ballerina.messaging.broker.auth.authorization.provider.MemoryDacHandler;
import io.ballerina.messaging.broker.auth.authorization.provider.NoOpMacHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class BrokerAuthConfiguration {
    public static final String NAMESPACE = "ballerina.broker.auth";
    private AuthenticationConfiguration authentication = new AuthenticationConfiguration();
    private AuthorizationConfiguration authorization = new AuthorizationConfiguration();

    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(AuthenticationConfiguration authentication) {
        this.authentication = authentication;
    }

    public AuthorizationConfiguration getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(AuthorizationConfiguration authorization) {
        this.authorization = authorization;
    }

    public static class CacheConfiguration {
        private int timeout = 15;
        private int size = 5000;

        public int getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }
    }

    public static class DacConfigurations {
        private String className = MemoryDacHandler.class.getCanonicalName();
        private Map<String, String> properties = new HashMap<String, String>();

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public Map<String, String> getProperties() {
            if (Objects.isNull(this.properties)) {
                return Collections.emptyMap();
            }
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }

    public static class MacConfigurations {
        private String className = NoOpMacHandler.class.getCanonicalName();
        private Map<String, String> properties = new HashMap<String, String>();

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public Map<String, String> getProperties() {
            if (Objects.isNull(this.properties)) {
                return Collections.emptyMap();
            }
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }

    public static class UserStoreConfiguration {
        private String className = FileBasedUserStore.class.getCanonicalName();
        private Map<String, String> properties = new HashMap<String, String>();

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public Map<String, String> getProperties() {
            if (Objects.isNull(this.properties)) {
                return Collections.emptyMap();
            }
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }
    }

    public static class AuthenticatorConfiguration {
        private String className = DefaultAuthenticator.class.getCanonicalName();
        private Map<String, Object> properties = new HashMap<String, Object>();

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }
    }

    public static class AuthorizationConfiguration {
        private boolean enabled = false;
        private UserStoreConfiguration userStore = new UserStoreConfiguration();
        private MacConfigurations mandatoryAccessController = new MacConfigurations();
        private DacConfigurations discretionaryAccessController = new DacConfigurations();
        private CacheConfiguration cache = new CacheConfiguration();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public UserStoreConfiguration getUserStore() {
            return this.userStore;
        }

        public void setUserStore(UserStoreConfiguration userStore) {
            this.userStore = userStore;
        }

        public MacConfigurations getMandatoryAccessController() {
            return this.mandatoryAccessController;
        }

        public void setMandatoryAccessController(MacConfigurations mandatoryAccessController) {
            this.mandatoryAccessController = mandatoryAccessController;
        }

        public DacConfigurations getDiscretionaryAccessController() {
            return this.discretionaryAccessController;
        }

        public void setDiscretionaryAccessController(DacConfigurations discretionaryAccessController) {
            this.discretionaryAccessController = discretionaryAccessController;
        }

        public CacheConfiguration getCache() {
            return this.cache;
        }

        public void setCache(CacheConfiguration cache) {
            this.cache = cache;
        }
    }

    public static class AuthenticationConfiguration {
        private boolean enabled = true;
        private AuthenticatorConfiguration authenticator = new AuthenticatorConfiguration();

        public AuthenticatorConfiguration getAuthenticator() {
            return this.authenticator;
        }

        public void setAuthenticator(AuthenticatorConfiguration authenticator) {
            this.authenticator = authenticator;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

