/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth;

import java.security.Principal;
import java.util.Objects;
import javax.security.auth.Subject;

public class UsernamePrincipal
implements Principal {
    private final String name;

    public UsernamePrincipal(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UsernamePrincipal) {
            UsernamePrincipal other = (UsernamePrincipal)obj;
            return this.name.equals(other.name);
        }
        return false;
    }

    public static Subject createSubject(String authorizationID) {
        Subject subject = new Subject();
        subject.getPrincipals().add(new UsernamePrincipal(authorizationID));
        return subject;
    }
}

