/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authentication.authenticator;

import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.authentication.AuthResult;
import io.ballerina.messaging.broker.auth.authentication.Authenticator;
import io.ballerina.messaging.broker.auth.authentication.jaas.PlainSaslCallbackHandler;
import io.ballerina.messaging.broker.auth.authentication.jaas.UserStoreLoginModule;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.common.StartupContext;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasAuthenticator
implements Authenticator {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaasAuthenticator.class);

    @Override
    public void initialize(StartupContext startupContext, UserStore userStore, Map<String, Object> properties) throws Exception {
        String jaasConfigPath = System.getProperty("java.security.auth.login.config");
        if (jaasConfigPath == null || jaasConfigPath.trim().isEmpty()) {
            Object jaasLoginModule = properties.get("loginModule");
            if (Objects.nonNull(jaasLoginModule)) {
                if (jaasLoginModule.toString().equals(UserStoreLoginModule.class.getCanonicalName())) {
                    properties.put("broker.user.store.connector", userStore);
                }
                Configuration jaasConfig = JaasAuthenticator.createJaasConfig(jaasLoginModule.toString(), properties);
                Configuration.setConfiguration(jaasConfig);
            } else {
                throw new AuthException("Jass login module have not been set.");
            }
        }
    }

    @Override
    public AuthResult authenticate(String username, char[] password) throws AuthException {
        LoginContext loginContext = null;
        try {
            Principal principal;
            Set<Principal> principals;
            PlainSaslCallbackHandler plainCallbackHandler = new PlainSaslCallbackHandler();
            plainCallbackHandler.setUsername(username);
            plainCallbackHandler.setPassword(password);
            loginContext = new LoginContext("BrokerSecurityConfig", plainCallbackHandler);
            loginContext.login();
            String userId = username;
            if (Objects.nonNull(loginContext.getSubject()) && Objects.nonNull(principals = loginContext.getSubject().getPrincipals()) && !principals.isEmpty() && Objects.nonNull(principal = principals.iterator().next())) {
                userId = principal.getName();
            }
            AuthResult authResult = new AuthResult(true, userId);
            return authResult;
        }
        catch (LoginException e) {
            throw new AuthException("Error while authenticating user with login module", e);
        }
        finally {
            if (Objects.nonNull(loginContext)) {
                try {
                    loginContext.logout();
                }
                catch (LoginException e) {
                    LOGGER.error("Error while logout from login module", (Throwable)e);
                }
            }
        }
    }

    private static Configuration createJaasConfig(String loginModuleClassName, Map<String, Object> options) {
        final AppConfigurationEntry[] entries = new AppConfigurationEntry[]{new AppConfigurationEntry(loginModuleClassName, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return entries;
            }
        };
    }
}

