/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization;

import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.UsernamePrincipal;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAction;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceAuthScope;
import io.ballerina.messaging.broker.auth.authorization.enums.ResourceType;
import io.ballerina.messaging.broker.common.ResourceNotFoundException;
import javax.security.auth.Subject;

public class AuthorizationHandler {
    private Authorizer authorizer;

    public AuthorizationHandler(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void handle(ResourceAuthScope brokerAuthScope, ResourceType resourceType, String resourceName, ResourceAction action, Subject subject) throws AuthException, AuthNotFoundException {
        try {
            if (!this.authorizer.authorize(brokerAuthScope.toString(), this.getUserFromSubject(subject)) && !this.authorizer.authorize(resourceType.toString(), resourceName, action.toString(), this.getUserFromSubject(subject))) {
                throw new AuthException("Unauthorized action on : " + resourceType.toString() + " resourceName: " + resourceName + " action: " + action.toString());
            }
        }
        catch (AuthServerException e) {
            throw new AuthException("Error occurred while authorizing on : " + resourceType.toString() + " resourceName: " + resourceName + " action: " + action.toString(), e);
        }
    }

    public void handle(ResourceType resourceType, String resourceName, ResourceAction action, Subject subject) throws AuthException, AuthNotFoundException {
        try {
            if (!this.authorizer.authorize(resourceType.toString(), resourceName, action.toString(), this.getUserFromSubject(subject))) {
                throw new AuthException(resourceType, resourceName, action);
            }
        }
        catch (AuthServerException e) {
            throw new AuthException("Error occurred while authorizing on : " + resourceType.toString() + " resourceName: " + resourceName + " action: " + action.toString(), e);
        }
    }

    public void handle(ResourceAuthScope authScope, Subject subject) throws AuthException {
        try {
            if (!this.authorizer.authorize(authScope.toString(), this.getUserFromSubject(subject))) {
                throw new AuthException("Unauthorized action on auth scope key : " + authScope.toString());
            }
        }
        catch (AuthNotFoundException | AuthServerException e) {
            throw new AuthException("Error occurred while authorizing auth scope key : " + authScope.toString(), e);
        }
    }

    public void createAuthResource(ResourceType resourceType, String resourceName, boolean durable, Subject subject) throws AuthException {
        try {
            this.authorizer.addProtectedResource(resourceType.toString(), resourceName, durable, this.getUserFromSubject(subject));
        }
        catch (AuthServerException e) {
            throw new AuthException("Error while creating " + (Object)((Object)resourceType) + " with name : " + resourceName, e);
        }
    }

    public void deleteAuthResource(ResourceType resourceType, String resourceName) throws AuthException, ResourceNotFoundException {
        try {
            this.authorizer.deleteProtectedResource(resourceType.toString(), resourceName);
        }
        catch (AuthServerException e) {
            throw new AuthException("Error while deleting " + (Object)((Object)resourceType) + " with name : " + resourceName, e);
        }
        catch (AuthNotFoundException e) {
            throw new ResourceNotFoundException("Error occurred while authorizing due to resource name : " + resourceName + " not found.");
        }
    }

    private String getUserFromSubject(Subject subject) {
        UsernamePrincipal usernamePrincipal = (UsernamePrincipal)subject.getPrincipals().iterator().next();
        return usernamePrincipal.getName();
    }
}

