/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.BrokerAuthConfiguration;
import io.ballerina.messaging.broker.auth.authorization.Authorizer;
import io.ballerina.messaging.broker.auth.authorization.DiscretionaryAccessController;
import io.ballerina.messaging.broker.auth.authorization.MandatoryAccessController;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.UserCacheEntry;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.ResourceCacheKey;
import io.ballerina.messaging.broker.auth.authorization.provider.MemoryDacHandler;
import io.ballerina.messaging.broker.common.StartupContext;
import io.ballerina.messaging.broker.common.config.BrokerConfigProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizer
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAuthorizer.class);
    private final MemoryDacHandler memoryDacHandler;
    private UserStore userStore;
    private LoadingCache<String, UserCacheEntry> userCache;
    private DiscretionaryAccessController externalDacHandler;
    private MandatoryAccessController macHandler;

    public DefaultAuthorizer(DiscretionaryAccessController externalDacHandler, MandatoryAccessController macHandler, UserStore userStore) {
        this.externalDacHandler = externalDacHandler;
        this.memoryDacHandler = new MemoryDacHandler();
        this.macHandler = macHandler;
        this.userStore = userStore;
    }

    @Override
    public void initialize(StartupContext startupContext) throws Exception {
        BrokerConfigProvider configProvider = (BrokerConfigProvider)startupContext.getService(BrokerConfigProvider.class);
        BrokerAuthConfiguration brokerAuthConfiguration = (BrokerAuthConfiguration)configProvider.getConfigurationObject("ballerina.broker.auth", BrokerAuthConfiguration.class);
        this.userCache = CacheBuilder.newBuilder().maximumSize((long)brokerAuthConfiguration.getAuthorization().getCache().getSize()).expireAfterWrite((long)brokerAuthConfiguration.getAuthorization().getCache().getTimeout(), TimeUnit.MINUTES).build((CacheLoader)new UserCacheLoader());
    }

    @Override
    public boolean authorize(String scopeName, String userId) throws AuthException, AuthServerException, AuthNotFoundException {
        try {
            if (userId != null) {
                UserCacheEntry userCacheEntry = (UserCacheEntry)this.userCache.get((Object)userId);
                boolean anyMatch = userCacheEntry.getAuthorizedScopes().stream().anyMatch(s -> s.equals(scopeName));
                if (anyMatch) {
                    LOGGER.debug("Scopes are loaded from cache for auth scope key : {} ", (Object)scopeName);
                    return true;
                }
                if (this.macHandler.authorize(scopeName, userCacheEntry.getUserGroups())) {
                    userCacheEntry.getAuthorizedScopes().add(scopeName);
                    return true;
                }
                return false;
            }
            throw new AuthException("user id cannot be null.");
        }
        catch (ExecutionException e) {
            throw new AuthServerException("Error occurred while retrieving authorizations from cache for scope name : " + scopeName, e);
        }
    }

    @Override
    public boolean authorize(String resourceType, String resourceName, String action, String userId) throws AuthException, AuthServerException, AuthNotFoundException {
        ResourceCacheKey resourceCacheKey = new ResourceCacheKey(resourceType, resourceName);
        try {
            if (userId != null) {
                boolean authorized;
                UserCacheEntry userCacheEntry = (UserCacheEntry)this.userCache.get((Object)userId);
                Set<String> authorizedActions = userCacheEntry.getAuthorizedResourceActions().get(resourceCacheKey);
                boolean bl = authorized = Objects.nonNull(authorizedActions) && authorizedActions.stream().anyMatch(s -> s.equals(action));
                if (authorized) {
                    LOGGER.debug("resourceName authorizations are loaded from cache for resourceType : {} resourceName: {}", (Object)resourceType, (Object)resourceName);
                    return true;
                }
                authorized = this.authorizeInDac(resourceType, resourceName, action, userId, userCacheEntry);
                if (authorized) {
                    if (Objects.isNull(authorizedActions)) {
                        authorizedActions = new HashSet<String>();
                        userCacheEntry.getAuthorizedResourceActions().put(resourceCacheKey, authorizedActions);
                    }
                    authorizedActions.add(action);
                    return true;
                }
                return false;
            }
            throw new AuthException("user id cannot be null.");
        }
        catch (ExecutionException e) {
            throw new AuthException("Error occurred while retrieving authorizations from cache for resourceType : " + resourceType + " resourceName: " + resourceName, e);
        }
    }

    private boolean authorizeInDac(String resourceType, String resourceName, String action, String userId, UserCacheEntry userCacheEntry) throws AuthServerException, AuthNotFoundException {
        boolean authorized = this.memoryDacHandler.authorize(resourceType, resourceName, action, userId, userCacheEntry.getUserGroups());
        if (!authorized) {
            authorized = this.externalDacHandler.authorize(resourceType, resourceName, action, userId, userCacheEntry.getUserGroups());
        }
        return authorized;
    }

    @Override
    public AuthResource getAuthResource(String resourceType, String resourceName) throws AuthServerException, AuthNotFoundException {
        AuthResource authResource = this.memoryDacHandler.getAuthResource(resourceType, resourceName);
        if (Objects.nonNull(authResource)) {
            return authResource;
        }
        return this.externalDacHandler.getAuthResource(resourceType, resourceName);
    }

    @Override
    public void addProtectedResource(String resourceType, String resourceName, boolean durable, String owner) throws AuthServerException {
        this.getDacHandler(durable).addResource(resourceType, resourceName, owner);
    }

    @Override
    public void deleteProtectedResource(String resourceType, String resourceName) throws AuthServerException, AuthNotFoundException {
        if (!this.memoryDacHandler.deleteResource(resourceType, resourceName)) {
            this.externalDacHandler.deleteResource(resourceType, resourceName);
        }
    }

    @Override
    public boolean addGroupsToResource(String resourceType, String resourceName, String action, List<String> groups) throws AuthServerException {
        boolean success = false;
        if (this.memoryDacHandler.addGroupsToResource(resourceType, resourceName, action, groups) || this.externalDacHandler.addGroupsToResource(resourceType, resourceName, action, groups)) {
            success = true;
        }
        return success;
    }

    @Override
    public boolean removeGroupFromResource(String resourceType, String resourceName, String action, String group) throws AuthServerException, AuthNotFoundException {
        boolean success = false;
        if (this.memoryDacHandler.removeGroupFromResource(resourceType, resourceName, action, group) || this.externalDacHandler.removeGroupFromResource(resourceType, resourceName, action, group)) {
            success = true;
        }
        return success;
    }

    @Override
    public boolean changeResourceOwner(String resourceType, String resourceName, String owner) throws AuthServerException, AuthNotFoundException, AuthException {
        if (!this.userStore.isUserExists(owner)) {
            throw new AuthException("Invalid username for the owner.");
        }
        boolean success = false;
        if (this.memoryDacHandler.changeResourceOwner(resourceType, resourceName, owner) || this.externalDacHandler.changeResourceOwner(resourceType, resourceName, owner)) {
            success = true;
        }
        return success;
    }

    private DiscretionaryAccessController getDacHandler(boolean durable) {
        if (durable) {
            return this.externalDacHandler;
        }
        return this.memoryDacHandler;
    }

    private class UserCacheLoader
    extends CacheLoader<String, UserCacheEntry> {
        private UserCacheLoader() {
        }

        public UserCacheEntry load(@Nonnull String userId) throws AuthException {
            UserCacheEntry userCacheEntry = new UserCacheEntry();
            userCacheEntry.setUserGroups(DefaultAuthorizer.this.userStore.getUserGroupsList(userId));
            return userCacheEntry;
        }
    }
}

