/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.AuthResource;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.resource.dao.AuthResourceDao;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AuthResourceInMemoryDao
implements AuthResourceDao {
    private Table<String, String, AuthResource> inMemoryResourceMap = HashBasedTable.create();

    @Override
    public void persist(AuthResource authResource) throws AuthServerException {
        String resourceName;
        String resourceType = authResource.getResourceType();
        if (this.inMemoryResourceMap.contains((Object)resourceType, (Object)(resourceName = authResource.getResourceName()))) {
            throw new AuthServerException("Auth resource already exists [" + resourceType + ", " + resourceName + "]");
        }
        this.inMemoryResourceMap.put((Object)resourceType, (Object)resourceName, (Object)authResource);
    }

    @Override
    public void update(AuthResource authResource) {
        this.inMemoryResourceMap.put((Object)authResource.getResourceType(), (Object)authResource.getResourceName(), (Object)authResource);
    }

    @Override
    public boolean delete(String resourceType, String resource) {
        AuthResource removedItem = (AuthResource)this.inMemoryResourceMap.remove((Object)resourceType, (Object)resource);
        return removedItem != null;
    }

    @Override
    public AuthResource read(String resourceType, String resource) {
        return (AuthResource)this.inMemoryResourceMap.get((Object)resourceType, (Object)resource);
    }

    @Override
    public List<AuthResource> readAll(String resourceType, String ownerId) {
        Map resourceMap = this.inMemoryResourceMap.row((Object)resourceType);
        if (Objects.nonNull(resourceMap)) {
            Collection authResources = resourceMap.values();
            return authResources.stream().filter(authResource -> authResource.getOwner().equals(ownerId)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<AuthResource> readAll(String resourceType, String action, String ownerId, List<String> userGroups) {
        Map resourceMap = this.inMemoryResourceMap.row((Object)resourceType);
        if (Objects.nonNull(resourceMap)) {
            Collection authResources = resourceMap.values();
            return authResources.stream().filter(authResource -> authResource.getOwner().equals(ownerId) || this.checkActionAndGroups(authResource.getActionsUserGroupsMap(), action, userGroups)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkActionAndGroups(Map<String, Set<String>> actionUserGroupsMap, String action, List<String> userGroups) {
        if (!Objects.nonNull(actionUserGroupsMap)) return false;
        Set<String> authorizedUserGroups = actionUserGroupsMap.get(action);
        if (!Objects.nonNull(authorizedUserGroups)) return false;
        if (!authorizedUserGroups.stream().anyMatch(userGroups::contains)) return false;
        return true;
    }

    @Override
    public boolean isExists(String resourceType, String resourceName) {
        return this.inMemoryResourceMap.contains((Object)resourceType, (Object)resourceName);
    }

    @Override
    public boolean updateOwner(String resourceType, String resourceName, String newOwner) {
        AuthResource authResource = (AuthResource)this.inMemoryResourceMap.get((Object)resourceType, (Object)resourceName);
        if (Objects.nonNull(authResource)) {
            authResource.setOwner(newOwner);
            return true;
        }
        return false;
    }

    @Override
    public boolean addGroups(String resourceType, String resourceName, String action, List<String> groups) {
        AuthResource authResource = (AuthResource)this.inMemoryResourceMap.get((Object)resourceType, (Object)resourceName);
        if (Objects.nonNull(authResource)) {
            Set userGroups = authResource.getActionsUserGroupsMap().computeIfAbsent(action, key -> new HashSet());
            userGroups.addAll(groups);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeGroup(String resourceType, String resourceName, String action, String group) {
        AuthResource authResource = (AuthResource)this.inMemoryResourceMap.get((Object)resourceType, (Object)resourceName);
        if (Objects.nonNull(authResource)) {
            Set userGroups = authResource.getActionsUserGroupsMap().computeIfAbsent(action, key -> new HashSet());
            userGroups.remove(group);
            return true;
        }
        return false;
    }
}

