/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.scope;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.ballerina.messaging.broker.auth.AuthNotFoundException;
import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.BrokerAuthConfiguration;
import io.ballerina.messaging.broker.auth.authorization.AuthScopeStore;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.scope.AuthScope;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.scope.dao.AuthScopeDao;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.scope.dao.impl.AuthScopeRdbmsDao;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.sql.DataSource;

public class AuthScopeStoreImpl
implements AuthScopeStore {
    private AuthScopeDao authScopeDao;
    private LoadingCache<String, AuthScope> authScopeCache;

    public AuthScopeStoreImpl(BrokerAuthConfiguration brokerAuthConfiguration, DataSource dataSource) {
        this.authScopeDao = new AuthScopeRdbmsDao(dataSource);
        this.authScopeCache = CacheBuilder.newBuilder().maximumSize((long)brokerAuthConfiguration.getAuthorization().getCache().getSize()).expireAfterWrite((long)brokerAuthConfiguration.getAuthorization().getCache().getTimeout(), TimeUnit.MINUTES).build((CacheLoader)new AuthScopeCacheLoader());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean authorize(String authScopeName, Set<String> userGroups) throws AuthNotFoundException {
        try {
            AuthScope authScope = (AuthScope)this.authScopeCache.get((Object)authScopeName);
            if (!Objects.nonNull(authScope)) return false;
            if (!authScope.getUserGroups().stream().anyMatch(userGroups::contains)) return false;
            return true;
        }
        catch (ExecutionException e) {
            throw new AuthNotFoundException("A scope was not found for the scope name: " + authScopeName, e);
        }
    }

    @Override
    public void update(String authScopeName, List<String> userGroups) throws AuthServerException {
        this.authScopeDao.update(authScopeName, userGroups);
        this.authScopeCache.invalidate((Object)authScopeName);
    }

    @Override
    public AuthScope read(String authScopeName) throws AuthServerException {
        return this.authScopeDao.read(authScopeName);
    }

    @Override
    public List<AuthScope> readAll() throws AuthServerException {
        return this.authScopeDao.readAll();
    }

    private class AuthScopeCacheLoader
    extends CacheLoader<String, AuthScope> {
        private AuthScopeCacheLoader() {
        }

        public AuthScope load(@Nonnull String scopeName) throws AuthNotFoundException, AuthServerException {
            AuthScope authScope = AuthScopeStoreImpl.this.read(scopeName);
            if (Objects.nonNull(authScope)) {
                return authScope;
            }
            throw new AuthNotFoundException("Scope does not found");
        }
    }
}

