/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.scope.dao.impl;

import io.ballerina.messaging.broker.auth.AuthServerException;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.scope.AuthScope;
import io.ballerina.messaging.broker.auth.authorization.authorizer.rdbms.scope.dao.AuthScopeDao;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;

public class AuthScopeRdbmsDao
extends AuthScopeDao {
    public AuthScopeRdbmsDao(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    public AuthScope read(String scopeName) throws AuthServerException {
        HashSet<String> userGroups = new HashSet<String>();
        String scopeId = null;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("SELECT s.SCOPE_NAME, sm.USER_GROUP_ID FROM MB_AUTH_SCOPE_MAPPING sm RIGHT JOIN ( SELECT SCOPE_ID, SCOPE_NAME FROM MB_AUTH_SCOPE WHERE SCOPE_NAME = ?) s ON s.SCOPE_ID = sm.SCOPE_ID");
            statement.setString(1, scopeName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String userGroup;
                if (Objects.isNull(scopeId)) {
                    scopeId = resultSet.getString(1);
                }
                if (!Objects.nonNull(userGroup = resultSet.getString(2))) continue;
                userGroups.add(userGroup);
            }
        }
        catch (SQLException e) {
            try {
                throw new AuthServerException("Error occurred while retrieving scope for name : " + scopeName, e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, resultSet);
                throw throwable;
            }
        }
        this.close(connection, statement, resultSet);
        if (Objects.nonNull(scopeId)) {
            return new AuthScope(scopeName, userGroups);
        }
        return null;
    }

    @Override
    public List<AuthScope> readAll() throws AuthServerException {
        HashMap<String, AuthScope> authScopes = new HashMap<String, AuthScope>();
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            statement = connection.prepareStatement("SELECT s.SCOPE_NAME, sm.USER_GROUP_ID FROM MB_AUTH_SCOPE_MAPPING sm RIGHT JOIN MB_AUTH_SCOPE s ON s.SCOPE_ID = sm.SCOPE_ID");
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String scopeName = resultSet.getString(1);
                AuthScope authScope = (AuthScope)authScopes.get(scopeName);
                if (Objects.isNull(authScope)) {
                    authScope = new AuthScope(scopeName, new HashSet<String>());
                    authScopes.put(scopeName, authScope);
                }
                if (!Objects.nonNull(resultSet.getString(2))) continue;
                authScope.addUserGroup(resultSet.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                throw new AuthServerException("Error occurred while retrieving scopes", e);
            }
            catch (Throwable throwable) {
                this.close(connection, statement, resultSet);
                throw throwable;
            }
        }
        this.close(connection, statement, resultSet);
        return new ArrayList<AuthScope>(authScopes.values());
    }

    @Override
    public void update(String scopeName, List<String> userGroups) throws AuthServerException {
        Connection connection = null;
        try {
            connection = this.getConnection();
            this.deleteGroups(scopeName, connection);
            this.persistGroups(scopeName, userGroups, connection);
            connection.commit();
        }
        catch (SQLException e) {
            throw new AuthServerException("Error occurred while updating groups for scope name : " + scopeName, e);
        }
        finally {
            this.close(connection);
        }
    }

    private void persistGroups(String scopeName, List<String> userGroups, Connection connection) throws AuthServerException {
        PreparedStatement insertUserGroupsStmt = null;
        try {
            insertUserGroupsStmt = connection.prepareStatement("INSERT INTO MB_AUTH_SCOPE_MAPPING (SCOPE_ID, USER_GROUP_ID) SELECT SCOPE_ID , ? FROM MB_AUTH_SCOPE WHERE SCOPE_NAME = ? ");
            for (String userGroup : userGroups) {
                insertUserGroupsStmt.setString(1, userGroup);
                insertUserGroupsStmt.setString(2, scopeName);
                insertUserGroupsStmt.addBatch();
            }
            insertUserGroupsStmt.executeBatch();
        }
        catch (SQLException e) {
            throw new AuthServerException("Error occurred while persisting groups for scope name : " + scopeName, e);
        }
        finally {
            this.close(insertUserGroupsStmt);
        }
    }

    private void deleteGroups(String scopeName, Connection connection) throws AuthServerException {
        PreparedStatement deleteUserGroupsStmt = null;
        try {
            deleteUserGroupsStmt = connection.prepareStatement("DELETE FROM MB_AUTH_SCOPE_MAPPING WHERE SCOPE_ID IN ( SELECT SCOPE_ID FROM MB_AUTH_SCOPE WHERE SCOPE_NAME = ?) ");
            deleteUserGroupsStmt.setString(1, scopeName);
            deleteUserGroupsStmt.execute();
        }
        catch (SQLException e) {
            throw new AuthServerException("Error occurred while deleting user groups scope for name : " + scopeName, e);
        }
        finally {
            this.close(deleteUserGroupsStmt);
        }
    }
}

