/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.messaging.broker.auth.authorization.provider;

import io.ballerina.messaging.broker.auth.AuthException;
import io.ballerina.messaging.broker.auth.authentication.AuthResult;
import io.ballerina.messaging.broker.auth.authorization.UserStore;
import io.ballerina.messaging.broker.auth.user.config.UserConfig;
import io.ballerina.messaging.broker.auth.user.config.UsersFile;
import io.ballerina.messaging.broker.auth.user.dto.User;
import io.ballerina.messaging.broker.common.StartupContext;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigProviderFactory;
import org.wso2.carbon.config.provider.ConfigProvider;

public class FileBasedUserStore
implements UserStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedUserStore.class);
    private static Map<String, User> userRegistry = new ConcurrentHashMap<String, User>();

    @Override
    public void initialize(StartupContext startupContext, Map<String, String> properties) throws Exception {
        String usersFilePath = System.getProperty("broker.users.config");
        Path usersYamlFile = usersFilePath == null || usersFilePath.trim().isEmpty() ? Paths.get("", "users.yaml").toAbsolutePath() : Paths.get(usersFilePath, new String[0]).toAbsolutePath();
        ConfigProvider configProvider = ConfigProviderFactory.getConfigProvider((Path)usersYamlFile, null);
        UsersFile usersFile = (UsersFile)configProvider.getConfigurationObject("wso2.broker.users", UsersFile.class);
        if (usersFile != null) {
            List<UserConfig> usersList = usersFile.getUserConfigs();
            for (UserConfig userConfig : usersList) {
                if (userConfig != null && userConfig.getUsername() != null) {
                    userRegistry.put(userConfig.getUsername(), new User(userConfig.getUsername(), userConfig.getPassword().toCharArray(), new HashSet<String>(userConfig.getRoles())));
                    continue;
                }
                LOGGER.error("User or username can not be null");
            }
        }
    }

    @Override
    public AuthResult authenticate(String username, char ... credentials) throws AuthException {
        if (Objects.isNull(username)) {
            throw new AuthException("Username cannot be null.");
        }
        User user = userRegistry.get(username);
        if (Objects.isNull(user)) {
            throw new AuthException("User not found for the given username.");
        }
        if (Arrays.equals(credentials, user.getPassword())) {
            return new AuthResult(true, username);
        }
        throw new AuthException("Password did not match with the configured user");
    }

    @Override
    public boolean isUserExists(String username) {
        return Objects.nonNull(userRegistry.get(username));
    }

    @Override
    public Set<String> getUserGroupsList(String userName) {
        User user = userRegistry.get(userName);
        if (user != null) {
            return user.getRoles();
        }
        return Collections.emptySet();
    }
}

