/*
 * Decompiled with CFR 0.152.
 */
package loophole.mvc.base;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import loophole.mvc.annotation.Kontrol;
import loophole.mvc.annotation.MethodType;
import loophole.mvc.annotation.Model;
import loophole.mvc.annotation.Validate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseKontroller {
    private static final String PACKAGES = System.getProperty("MVC_CONTROLLER_PKGS") != null ? System.getProperty("MVC_CONTROLLER_PKGS") : "";
    private static Logger log = LoggerFactory.getLogger(BaseKontroller.class);
    private static List<Class<?>> ktrlList = new ArrayList();
    private List<String> errors = new ArrayList<String>();
    private Map<String, String> fieldErrors = new LinkedHashMap<String, String>();
    private HttpServletRequest request;
    private HttpServletResponse response;

    public BaseKontroller(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    private static void loadKontrollers(File d, String packageNm) throws ClassNotFoundException {
        File[] files = d.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                Class<?> clazz;
                if (file.isDirectory()) {
                    BaseKontroller.loadKontrollers(file, packageNm + "." + file.getName());
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                Object fileNm = file.getName().replaceAll("\\.class", "");
                if (packageNm != null && packageNm.length() > 0) {
                    fileNm = packageNm.replaceAll("^\\.", "") + "." + (String)fileNm;
                }
                if (!BaseKontroller.class.equals((clazz = Class.forName((String)fileNm)).getSuperclass())) continue;
                ktrlList.add(clazz);
            }
        }
    }

    private static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }

    public String execute() throws ServletException {
        String forward = null;
        for (Class<?> clazz : ktrlList) {
            for (Method method : clazz.getMethods()) {
                if (!method.isAnnotationPresent(Kontrol.class)) continue;
                Kontrol c = method.getAnnotation(Kontrol.class);
                if (!this.request.getRequestURI().contains(c.path() + ".ktrl") || !MethodType.valueOf(this.request.getMethod()).equals((Object)c.method())) continue;
                try {
                    Annotation v;
                    Constructor<?> constructor = clazz.getDeclaredConstructor(HttpServletRequest.class, HttpServletResponse.class);
                    BaseKontroller ctrl = (BaseKontroller)constructor.newInstance(this.request, this.response);
                    for (Field field : clazz.getDeclaredFields()) {
                        Model m;
                        if (!field.isAnnotationPresent(Model.class) || (m = field.getAnnotation(Model.class)).name().length() <= 0) continue;
                        field.setAccessible(true);
                        if (this.request.getAttribute(m.name()) == null) continue;
                        field.set(ctrl, this.request.getAttribute(m.name()));
                    }
                    Enumeration parameterNames = this.request.getParameterNames();
                    while (parameterNames.hasMoreElements()) {
                        String param = (String)parameterNames.nextElement();
                        this.setFieldFromParams(ctrl, param, this.request);
                    }
                    for (Method validateMethod : clazz.getMethods()) {
                        if (!validateMethod.isAnnotationPresent(Validate.class)) continue;
                        v = validateMethod.getAnnotation(Validate.class);
                        if (!validateMethod.getName().equalsIgnoreCase("validate" + method.getName())) continue;
                        forward = v.input();
                        Method m = clazz.getDeclaredMethod(validateMethod.getName(), new Class[0]);
                        m.invoke((Object)ctrl, new Object[0]);
                    }
                    if (!ctrl.hasErrors()) {
                        Method m = clazz.getDeclaredMethod(method.getName(), new Class[0]);
                        forward = (String)m.invoke((Object)ctrl, new Object[0]);
                    }
                    for (Field field : clazz.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(Model.class) || (v = field.getAnnotation(Model.class)).name().length() <= 0) continue;
                        field.setAccessible(true);
                        if (field.get(ctrl) != null) {
                            this.request.setAttribute(v.name(), field.get(ctrl));
                            continue;
                        }
                        this.request.setAttribute(v.name(), null);
                        try {
                            this.request.setAttribute(v.name(), field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    this.request.setAttribute("errors", ctrl.getErrors());
                    this.request.setAttribute("fieldErrors", ctrl.getFieldErrors());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    log.error(ex.toString(), (Throwable)ex);
                    throw new ServletException(ex.toString(), (Throwable)ex);
                }
            }
        }
        return forward;
    }

    private void setFieldFromParams(Object ctrl, String param, HttpServletRequest request) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        if (param != null) {
            HashMap<String, String> requestMap = new HashMap<String, String>();
            for (String name : param.split("\\.")) {
                for (Field field : BaseKontroller.getAllFields(ctrl.getClass())) {
                    Type valueType;
                    Model v = field.getAnnotation(Model.class);
                    String key = null;
                    if (name.contains("[")) {
                        key = name.replaceAll(".*\\[", "").replaceAll("\\'", "").replaceAll("\\].*", "");
                        name = name.substring(0, name.indexOf("["));
                        requestMap.put(key, request.getParameter(param));
                    }
                    if ((v != null || !field.getName().equals(name)) && (v == null || !name.equals(v.name()))) continue;
                    field.setAccessible(true);
                    if (!requestMap.isEmpty() && field.getType().getName().equals("java.util.Map")) {
                        Type type = field.getGenericType();
                        if (type instanceof ParameterizedType) {
                            Type keyType = ((ParameterizedType)type).getActualTypeArguments()[0];
                            valueType = ((ParameterizedType)type).getActualTypeArguments()[1];
                            Map map = (Map)Map.class.cast(field.get(ctrl));
                            for (String k : requestMap.keySet()) {
                                Object keyOb = null;
                                Object valOb = null;
                                Class<?> theClass = Class.forName(keyType.getTypeName());
                                Constructor<?> cons = theClass.getConstructor(String.class);
                                keyOb = cons.newInstance(k);
                                theClass = Class.forName(valueType.getTypeName());
                                cons = theClass.getConstructor(String.class);
                                valOb = cons.newInstance(requestMap.get(k));
                                log.debug("Setting " + param + " : " + keyOb + " -  " + valOb);
                                map.put(keyOb, valOb);
                            }
                            field.set(ctrl, map);
                        }
                    } else if (field.getType().getName().equals("java.util.List") && request.getParameter(param) != null) {
                        Map parameterMap = request.getParameterMap();
                        Type type = field.getGenericType();
                        if (type instanceof ParameterizedType) {
                            valueType = ((ParameterizedType)type).getActualTypeArguments()[0];
                            List list = (List)List.class.cast(field.get(ctrl));
                            for (String p : (String[])parameterMap.get(param)) {
                                Object valOb = null;
                                Class<?> theClass = Class.forName(valueType.getTypeName());
                                Constructor<?> cons = theClass.getConstructor(String.class);
                                valOb = cons.newInstance(p);
                                log.debug("Setting " + param + " : " + valOb);
                                list.add(valOb);
                            }
                            field.set(ctrl, list);
                        }
                    } else {
                        log.debug("Setting " + param + " : " + request.getParameter(param));
                        if (field.getType().getName().equals("java.lang.String")) {
                            field.set(ctrl, request.getParameter(param));
                        } else if (field.getType().getName().equals("java.lang.Boolean")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Boolean.parseBoolean(request.getParameter(param)));
                            }
                        } else if (field.getType().getName().equals("java.lang.Byte")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Byte.parseByte(request.getParameter(param)));
                            }
                        } else if (field.getType().getName().equals("java.lang.Character")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Character.valueOf(request.getParameter(param).charAt(0)));
                            }
                        } else if (field.getType().getName().equals("java.lang.Double")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Double.parseDouble(request.getParameter(param)));
                            }
                        } else if (field.getType().getName().equals("java.lang.Float")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Float.valueOf(Float.parseFloat(request.getParameter(param))));
                            }
                        } else if (field.getType().getName().equals("java.lang.Integer")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Integer.parseInt(request.getParameter(param)));
                            }
                        } else if (field.getType().getName().equals("java.lang.Long")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Long.parseLong(request.getParameter(param)));
                            }
                        } else if (field.getType().getName().equals("java.lang.Short")) {
                            if (!StringUtils.isEmpty((CharSequence)request.getParameter(param))) {
                                field.set(ctrl, Short.parseShort(request.getParameter(param)));
                            }
                        } else if (field.get(ctrl) == null) {
                            field.set(ctrl, null);
                            try {
                                field.set(ctrl, field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                // empty catch block
                            }
                        }
                    }
                    ctrl = field.get(ctrl);
                }
            }
        }
    }

    public boolean hasErrors() {
        return !this.fieldErrors.isEmpty() || !this.errors.isEmpty();
    }

    public void addFieldError(String error, String message) {
        this.fieldErrors.put(error, message);
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public Map<String, String> getFieldErrors() {
        return this.fieldErrors;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    static {
        for (String packageNm : PACKAGES.split(",")) {
            ClassLoader classLoader = BaseKontroller.class.getClassLoader();
            String path = packageNm.replace('.', '/');
            try {
                Enumeration<URL> resources = classLoader.getResources(path);
                ArrayList<File> dirs = new ArrayList<File>();
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    dirs.add(new File(resource.getFile()));
                }
                for (File directory : dirs) {
                    BaseKontroller.loadKontrollers(directory, packageNm);
                }
            }
            catch (IOException | ClassNotFoundException ex) {
                log.error(ex.toString(), (Throwable)ex);
            }
        }
    }
}

