/*
 * Decompiled with CFR 0.152.
 */
package loophole.mvc.config;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.WebApplicationTemplateResolver;
import org.thymeleaf.web.IWebApplication;
import org.thymeleaf.web.servlet.JavaxServletWebApplication;

@WebListener
public class TemplateConfig
implements ServletContextListener {
    private static final String TEMPLATE_ENGINE = "com.thymeleafexamples.thymeleaf3.TemplateEngineInstance";

    public void contextInitialized(ServletContextEvent sce) {
        TemplateEngine engine = this.templateEngine(sce.getServletContext());
        sce.getServletContext().setAttribute(TEMPLATE_ENGINE, (Object)engine);
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private TemplateEngine templateEngine(ServletContext servletContext) {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver(this.templateResolver(servletContext));
        return engine;
    }

    private ITemplateResolver templateResolver(ServletContext servletContext) {
        JavaxServletWebApplication webApp = JavaxServletWebApplication.buildApplication((ServletContext)servletContext);
        WebApplicationTemplateResolver resolver = new WebApplicationTemplateResolver((IWebApplication)webApp);
        resolver.setPrefix("/");
        resolver.setSuffix(".html");
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCacheable(true);
        resolver.setCacheTTLMs(Long.valueOf(60000L));
        resolver.setCharacterEncoding("UTF-8");
        return resolver;
    }

    public static TemplateEngine getTemplateEngine(ServletContext context) {
        return (TemplateEngine)context.getAttribute(TEMPLATE_ENGINE);
    }
}

