/*
 * Decompiled with CFR 0.152.
 */
package loophole.mvc.filter;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(urlPatterns={"/", "*.ktrl", "*.html"})
public class CSRFFilter
implements Filter {
    private static Logger log = LoggerFactory.getLogger(CSRFFilter.class);
    public static final String _CSRF = "_csrf";
    private static final SecureRandom random = new SecureRandom();

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        log.debug("CSRF parameter token is " + request.getParameter(_CSRF));
        log.debug("CSRF sesson token is " + httpServletRequest.getSession().getAttribute(_CSRF));
        String _csrf = (String)httpServletRequest.getSession().getAttribute(_CSRF);
        if (_csrf == null || _csrf.equals(request.getParameter(_CSRF))) {
            log.debug("CSRF token is valid for " + httpServletRequest.getRequestURL());
            if (_csrf == null || httpServletRequest.getMethod().equalsIgnoreCase("POST")) {
                _csrf = new BigInteger(165, random).toString(36).toUpperCase();
                httpServletRequest.getSession().setAttribute(_CSRF, (Object)_csrf);
            }
            filterChain.doFilter(request, response);
            return;
        }
        log.debug("CSRF token is invalid for " + httpServletRequest.getRequestURL());
        httpServletRequest.getSession().invalidate();
        log.debug("Session invalidated");
        httpServletResponse.sendRedirect(httpServletRequest.getContextPath());
    }

    public void destroy() {
    }
}

