/*
 * Decompiled with CFR 0.152.
 */
package loophole.mvc.filter;

import java.io.IOException;
import java.security.SecureRandom;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletResponse;

@WebFilter(urlPatterns={"/*"})
public class SecurityFilter
implements Filter {
    public static final String _CSRF = "_csrf";
    private static final SecureRandom random = new SecureRandom();
    private static final String CSP_HEADER = "Content-Security-Policy";
    private static final String CSP_VALUE = "frame-ancestors 'self';";
    private static final String X_CONTENT_TYPE_HEADER = "X-Content-Type-Options";
    private static final String X_CONTENT_TYPE_VALUE = "nosniff";
    private static final String X_XSS_PROTECT_HEADER = "X-XSS-Protection";
    private static final String X_XSS_PROTECT_VALUE = "1; mode=block";
    private static final String TRANSPORT_SECURITY_HEADER = "Strict-Transport-Security";
    private static final String TRANSPORT_SECURITY_VALUE = "max-age=31536000";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.addHeader(CSP_HEADER, CSP_VALUE);
        httpServletResponse.addHeader(X_CONTENT_TYPE_HEADER, X_CONTENT_TYPE_VALUE);
        httpServletResponse.addHeader(X_XSS_PROTECT_HEADER, X_XSS_PROTECT_VALUE);
        httpServletResponse.addHeader(X_CONTENT_TYPE_HEADER, X_CONTENT_TYPE_VALUE);
        httpServletResponse.addHeader(TRANSPORT_SECURITY_HEADER, TRANSPORT_SECURITY_VALUE);
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }
}

