/*
 * Decompiled with CFR 0.152.
 */
package io.bayberry.aloha.ext.spring.local;

import io.bayberry.aloha.Channel;
import io.bayberry.aloha.Listener;
import io.bayberry.aloha.LocalMessageBus;
import io.bayberry.aloha.MessageBus;
import io.bayberry.aloha.ext.spring.local.LocalSpringListener;
import io.bayberry.aloha.ext.spring.local.SpringEventProxy;
import io.bayberry.aloha.ext.spring.local.annotation.SpringSubscriber;
import io.bayberry.aloha.support.GenericLocalMessageBus;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationEventMulticaster;

public class LocalSpringMessageBus
extends GenericLocalMessageBus {
    private final ApplicationContext applicationContext;
    private final SpringEventProxy springEventProxy;

    public LocalSpringMessageBus(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.springEventProxy = new SpringEventProxy((MessageBus)this);
        this.onCreate();
    }

    public Listener bindListener(Channel channel) {
        return new LocalSpringListener(channel, (LocalMessageBus)this);
    }

    public void post(Object message) {
        this.post(null, message);
    }

    public void post(Channel channel, Object message) {
        this.applicationContext.publishEvent(message);
    }

    public void onStart() {
        this.applicationContext.getBeansWithAnnotation(SpringSubscriber.class).values().forEach(x$0 -> super.register(x$0));
        ((ConfigurableApplicationContext)this.applicationContext).addApplicationListener((ApplicationListener)this.springEventProxy);
        super.onStart();
    }

    public void onDestroy() {
        ((ApplicationEventMulticaster)this.applicationContext.getBean("applicationEventMulticaster", ApplicationEventMulticaster.class)).removeApplicationListener((ApplicationListener)this.springEventProxy);
        super.onDestroy();
    }
}

