/*
 * Decompiled with CFR 0.152.
 */
package io.bayberry.aloha.ext.spring.local;

import io.bayberry.aloha.Channel;
import io.bayberry.aloha.Listener;
import io.bayberry.aloha.MessageBus;
import io.bayberry.aloha.util.Reflection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;

public class SpringEventProxy
implements ApplicationListener {
    private static final Reflection reflection = new Reflection();
    private MessageBus messageBus;

    public SpringEventProxy(MessageBus messageBus) {
        this.messageBus = messageBus;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Object source = event instanceof PayloadApplicationEvent ? ((PayloadApplicationEvent)event).getPayload() : event.getSource();
        this.getCandidateChannels(source.getClass()).forEach(channel -> {
            Listener listener = this.messageBus.getListenerRegistry().getListener(channel);
            if (listener == null) {
                return;
            }
            listener.notifyAll(source);
        });
    }

    private List<Channel> getCandidateChannels(Class messageType) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        channels.add(this.messageBus.getChannelResolver().resolve(messageType));
        channels.addAll(reflection.getAllInterfaces(messageType).stream().map(this::resolveChannel).collect(Collectors.toList()));
        reflection.getAllSuperClasses(messageType).forEach(superClass -> {
            channels.add(this.resolveChannel((Class)superClass));
            channels.addAll(reflection.getAllInterfaces(superClass).stream().map(this::resolveChannel).collect(Collectors.toList()));
        });
        return channels;
    }

    private Channel resolveChannel(Class eventType) {
        return this.messageBus.getChannelResolver().resolve(eventType);
    }
}

