/*
 * Decompiled with CFR 0.152.
 */
package io.bayberry.aloha.ext.spring.redis;

import io.bayberry.aloha.Channel;
import io.bayberry.aloha.ChannelResolver;
import io.bayberry.aloha.Listener;
import io.bayberry.aloha.RemoteMessageBus;
import io.bayberry.aloha.ext.spring.RemoteSpringMessageBus;
import io.bayberry.aloha.ext.spring.redis.RedisListener;
import io.bayberry.aloha.ext.spring.redis.RedisMessageBusOptions;
import io.bayberry.aloha.ext.spring.redis.annotation.RedisSubscriber;
import io.bayberry.aloha.support.AsyncListenerDecorator;
import io.bayberry.aloha.support.PrefixChannelResolverDecorator;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisMessageBus
extends RemoteSpringMessageBus {
    private static final RedisMessageBusOptions DEFAULT_SETTINGS = new RedisMessageBusOptions("mb:");
    private RedisTemplate<String, String> redisTemplate;
    private RedisMessageBusOptions options;

    public RedisMessageBus(ApplicationContext applicationContext) {
        this(applicationContext, DEFAULT_SETTINGS);
    }

    public RedisMessageBus(ApplicationContext applicationContext, RedisMessageBusOptions options) {
        super(applicationContext);
        this.options = options;
        super.onCreate();
    }

    public void onStart() {
        this.applicationContext.getBeansWithAnnotation(RedisSubscriber.class).values().forEach(x$0 -> super.register(x$0));
        this.redisTemplate = (RedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        super.onStart();
    }

    public ChannelResolver initChannelResolver() {
        return new PrefixChannelResolverDecorator(this.options.getChannelPrefix(), super.initChannelResolver());
    }

    public Listener bindListener(Channel channel) {
        return new AsyncListenerDecorator((Listener)new RedisListener(channel, this.redisTemplate, (RemoteMessageBus)this));
    }

    public void post(Channel channel, Object message) {
        this.redisTemplate.opsForList().rightPush((Object)channel.getName(), (Object)((String)this.getSerializer().serialize(message)));
    }
}

