/*
 * Decompiled with CFR 0.152.
 */
package io.bayberry.aloha.spring.local;

import io.bayberry.aloha.Channel;
import io.bayberry.aloha.Command;
import io.bayberry.aloha.Listener;
import io.bayberry.aloha.ListenerResolver;
import io.bayberry.aloha.LocalMessageBus;
import io.bayberry.aloha.MessageBus;
import io.bayberry.aloha.Publisher;
import io.bayberry.aloha.Receiver;
import io.bayberry.aloha.spring.SpringListenerResolver;
import io.bayberry.aloha.spring.local.LocalSpringReceiver;
import io.bayberry.aloha.spring.local.SpringEventProxy;
import io.bayberry.aloha.spring.local.annotation.SpringEventListeners;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ApplicationEventMulticaster;

public class LocalSpringMessageBus
extends LocalMessageBus
implements Publisher {
    private ApplicationContext applicationContext;
    private SpringEventProxy springEventProxy;
    private PublishCommand publishCommand;

    public LocalSpringMessageBus(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.springEventProxy = new SpringEventProxy((MessageBus)this);
    }

    public void publish(Object message) {
        this.publish(null, message);
    }

    public void publish(Channel channel, Object message) {
        super.post((Command)this.publishCommand, channel, message);
    }

    public void onStart() {
        this.applicationContext.getBeansWithAnnotation(SpringEventListeners.class).values().forEach(x$0 -> super.register(x$0));
        ((ConfigurableApplicationContext)this.applicationContext).addApplicationListener((ApplicationListener)this.springEventProxy);
        this.publishCommand = new PublishCommand();
        super.onStart();
    }

    public void onDestroy() {
        ((ApplicationEventMulticaster)this.applicationContext.getBean("applicationEventMulticaster", ApplicationEventMulticaster.class)).removeApplicationListener((ApplicationListener)this.springEventProxy);
        super.onDestroy();
    }

    protected ListenerResolver initListenerResolver() {
        return new SpringListenerResolver(this.applicationContext);
    }

    protected Receiver bindReceiver(Listener listener) {
        return new LocalSpringReceiver(listener.getChannel(), this);
    }

    public class PublishCommand
    implements Command {
        public void execute(Channel channel, Object message) {
            LocalSpringMessageBus.this.applicationContext.publishEvent(message);
        }
    }
}

