/*
 * Decompiled with CFR 0.152.
 */
package io.bayberry.aloha.spring.local;

import io.bayberry.aloha.Channel;
import io.bayberry.aloha.MessageBus;
import io.bayberry.aloha.util.Reflection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;

public class SpringEventProxy
implements ApplicationListener {
    private MessageBus messageBus;

    public SpringEventProxy(MessageBus messageBus) {
        this.messageBus = messageBus;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Object source = event instanceof PayloadApplicationEvent ? ((PayloadApplicationEvent)event).getPayload() : event.getSource();
        this.getCandidateChannels(source.getClass()).forEach(channel -> {
            Set receivers = this.messageBus.getReceiverRegistry().getReceivers(channel);
            if (receivers == null) {
                return;
            }
            receivers.forEach(receiver -> receiver.notifyAll(source));
        });
    }

    private List<Channel> getCandidateChannels(Class messageType) {
        ArrayList<Channel> channels = new ArrayList<Channel>();
        channels.add(this.messageBus.getChannelResolver().resolve(messageType));
        channels.addAll(Reflection.getAllInterfaces((Class)messageType).stream().map(this::resolveChannel).collect(Collectors.toList()));
        Reflection.getAllSuperClasses((Class)messageType).forEach(superClass -> {
            channels.add(this.resolveChannel((Class)superClass));
            channels.addAll(Reflection.getAllInterfaces((Class)superClass).stream().map(this::resolveChannel).collect(Collectors.toList()));
        });
        return channels;
    }

    private Channel resolveChannel(Class eventType) {
        return this.messageBus.getChannelResolver().resolve(eventType);
    }
}

