/*
 * Decompiled with CFR 0.152.
 */
package io.bayberry.aloha.spring.redis;

import io.bayberry.aloha.Channel;
import io.bayberry.aloha.ChannelResolver;
import io.bayberry.aloha.Command;
import io.bayberry.aloha.Listener;
import io.bayberry.aloha.ListenerResolver;
import io.bayberry.aloha.Producer;
import io.bayberry.aloha.Publisher;
import io.bayberry.aloha.Receiver;
import io.bayberry.aloha.RemoteMessageBus;
import io.bayberry.aloha.spring.SpringListenerResolver;
import io.bayberry.aloha.spring.redis.RedisMessageBusOptions;
import io.bayberry.aloha.spring.redis.RedisReceiver;
import io.bayberry.aloha.spring.redis.annotation.RedisListeners;
import io.bayberry.aloha.support.AsyncReceiverDecorator;
import io.bayberry.aloha.support.PrefixChannelResolverDecorator;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisMessageBus
extends RemoteMessageBus
implements Publisher,
Producer {
    private static final RedisMessageBusOptions DEFAULT_SETTINGS = new RedisMessageBusOptions("mb:");
    private RedisTemplate<String, String> redisTemplate;
    private RedisMessageBusOptions options;
    private ApplicationContext applicationContext;
    private ProduceCommand produceCommand;
    private PublishCommand publishCommand;

    public RedisMessageBus(ApplicationContext applicationContext) {
        this(applicationContext, DEFAULT_SETTINGS);
    }

    public RedisMessageBus(ApplicationContext applicationContext, RedisMessageBusOptions options) {
        this.applicationContext = applicationContext;
        this.options = options;
    }

    public void onStart() {
        this.applicationContext.getBeansWithAnnotation(RedisListeners.class).values().forEach(x$0 -> super.register(x$0));
        this.redisTemplate = (RedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        this.produceCommand = new ProduceCommand();
        this.publishCommand = new PublishCommand();
        super.onStart();
    }

    protected ListenerResolver initListenerResolver() {
        return new SpringListenerResolver(this.applicationContext);
    }

    public ChannelResolver initChannelResolver() {
        return new PrefixChannelResolverDecorator(this.options.getChannelPrefix(), super.initChannelResolver());
    }

    protected Receiver bindReceiver(Listener listener) {
        return new AsyncReceiverDecorator((Receiver)new RedisReceiver(listener.getChannel(), this.redisTemplate, this));
    }

    public void produce(Object message) {
        this.produce(this.getChannelResolver().resolve(message.getClass()), message);
    }

    public void produce(Channel channel, Object message) {
        super.post((Command)this.produceCommand, channel, message);
    }

    public void publish(Object message) {
        this.publish(this.getChannelResolver().resolve(message.getClass()), message);
    }

    public void publish(Channel channel, Object message) {
        this.post(this.publishCommand, channel, message);
    }

    public class PublishCommand
    implements Command {
        public void execute(Channel channel, Object message) {
            RedisMessageBus.this.redisTemplate.convertAndSend(channel.getName(), RedisMessageBus.this.getSerializer().serialize(message));
        }
    }

    private class ProduceCommand
    implements Command {
        private ProduceCommand() {
        }

        public void execute(Channel channel, Object message) {
            RedisMessageBus.this.redisTemplate.opsForList().rightPush((Object)channel.getName(), (Object)((String)RedisMessageBus.this.getSerializer().serialize(message)));
        }
    }
}

