/*
 * Decompiled with CFR 0.152.
 */
package io.bayberry.aloha.spring.redis;

import io.bayberry.aloha.Channel;
import io.bayberry.aloha.RemoteMessageBus;
import io.bayberry.aloha.RemoteReceiver;
import io.bayberry.aloha.exception.AlohaException;
import io.bayberry.aloha.util.LoopRunner;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisReceiver
extends RemoteReceiver {
    private RedisTemplate<String, String> redisTemplate;

    public RedisReceiver(Channel channel, RedisTemplate<String, String> redisTemplate, RemoteMessageBus messageBus) {
        super(channel, messageBus);
        this.redisTemplate = redisTemplate;
        this.onCreate();
    }

    protected void onStart() {
        new LoopRunner().run(() -> {
            String message = (String)this.redisTemplate.opsForList().leftPop((Object)super.getChannel().getName(), 3000L, TimeUnit.MILLISECONDS);
            if (message != null) {
                super.notifyAll((Object)message);
            }
        }, exception -> {
            try {
                this.handleException((Exception)exception, null);
            }
            catch (Exception error) {
                throw new AlohaException((Throwable)error);
            }
        });
    }
}

