/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.product.v1.impl;

import io.bdeploy.api.product.v1.DependencyFetcher;
import io.bdeploy.api.product.v1.impl.ScopedManifestKey;
import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.ManifestExistsOperation;
import io.bdeploy.bhive.op.ManifestLexicalMaxTagOperation;
import io.bdeploy.common.util.OsHelper;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;

public class LocalDependencyFetcher
implements DependencyFetcher {
    @Override
    public SortedSet<Manifest.Key> fetch(BHive hive, SortedSet<String> specs, OsHelper.OperatingSystem os) {
        TreeSet<Manifest.Key> smks = new TreeSet<Manifest.Key>();
        for (String dep : specs) {
            Manifest.Key resolved = LocalDependencyFetcher.resolveSingleLocal(hive, dep, os);
            if (resolved == null) {
                throw new IllegalStateException("Cannot resolve dependency " + dep + " for " + (Object)((Object)os));
            }
            smks.add(resolved);
        }
        return smks;
    }

    public static Manifest.Key resolveSingleLocal(BHive hive, String spec, OsHelper.OperatingSystem os) {
        Manifest.Key tmp = null;
        if (spec.contains(":")) {
            tmp = Manifest.Key.parse(spec);
        } else {
            Optional<String> id = hive.execute(new ManifestLexicalMaxTagOperation().setManifestName(ScopedManifestKey.createScopedName(spec, os)));
            if (id.isPresent()) {
                tmp = new Manifest.Key(spec, id.get());
            }
        }
        if (tmp == null) {
            return null;
        }
        ScopedManifestKey result = ScopedManifestKey.parse(tmp.toString(), os);
        Boolean exists = hive.execute(new ManifestExistsOperation().setManifest(result.getKey()));
        if (!Boolean.TRUE.equals(exists)) {
            if (Boolean.TRUE.equals(hive.execute(new ManifestExistsOperation().setManifest(tmp)))) {
                return tmp;
            }
            return null;
        }
        return result.getKey();
    }
}

