/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.api.product.v1.impl;

import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.common.util.OsHelper;

public class ScopedManifestKey {
    private final String name;
    private final OsHelper.OperatingSystem os;
    private final String tag;

    public ScopedManifestKey(String name, OsHelper.OperatingSystem os, String tag) {
        this.name = name;
        this.os = os;
        this.tag = tag;
    }

    public static ScopedManifestKey parse(Manifest.Key key) {
        String name = key.getName();
        String tag = key.getTag();
        int lastSlash = name.lastIndexOf(47);
        try {
            return new ScopedManifestKey(name.substring(0, lastSlash), OsHelper.OperatingSystem.valueOf(name.substring(lastSlash + 1).toUpperCase()), tag);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ScopedManifestKey parse(String key, OsHelper.OperatingSystem os) {
        Manifest.Key k = Manifest.Key.parse(key);
        return new ScopedManifestKey(k.getName(), os, k.getTag());
    }

    public static String createScopedName(String spec, OsHelper.OperatingSystem os) {
        return spec + '/' + os.name().toLowerCase();
    }

    public Manifest.Key getKey() {
        return new Manifest.Key(ScopedManifestKey.createScopedName(this.name, this.os), this.tag);
    }

    public OsHelper.OperatingSystem getOperatingSystem() {
        return this.os;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public String toString() {
        return this.getKey().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.os == null ? 0 : this.os.hashCode());
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScopedManifestKey other = (ScopedManifestKey)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.os != other.os) {
            return false;
        }
        return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
    }
}

