/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive;

import com.codahale.metrics.Timer;
import io.bdeploy.bhive.BHiveExecution;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.objects.ManifestDatabase;
import io.bdeploy.bhive.objects.ObjectDatabase;
import io.bdeploy.bhive.objects.ObjectManager;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.metrics.Metrics;
import io.bdeploy.common.util.ExceptionHelper;
import io.bdeploy.common.util.NamedDaemonThreadFactory;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.jersey.activity.JerseyBroadcastingActivityReporter;
import io.bdeploy.jersey.audit.AuditRecord;
import io.bdeploy.jersey.audit.Auditor;
import io.bdeploy.jersey.audit.NullAuditor;
import io.bdeploy.jersey.audit.RollingFileAuditor;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BHive
implements AutoCloseable,
BHiveExecution {
    private static final Logger log = LoggerFactory.getLogger(BHive.class);
    private final URI uri;
    private final FileSystem zipFs;
    private final Path objTmp;
    private final Path markerTmp;
    private final ObjectDatabase objects;
    private final ManifestDatabase manifests;
    private final ActivityReporter reporter;
    private final Auditor auditor;
    private int parallelism = 4;

    public BHive(URI uri, ActivityReporter reporter) {
        this(uri, null, reporter);
    }

    public BHive(URI uri, Auditor auditor, ActivityReporter reporter) {
        Path relRoot;
        this.uri = uri;
        if (uri.getScheme().equals("jar") || uri.getScheme().equals("file") && uri.toString().toLowerCase().endsWith(".zip")) {
            try {
                if (!uri.getScheme().equals("jar")) {
                    uri = URI.create("jar:" + uri);
                }
                TreeMap<String, Object> env = new TreeMap<String, Object>();
                env.put("create", "true");
                env.put("useTempFile", Boolean.TRUE);
                this.zipFs = FileSystems.newFileSystem(uri, env);
            }
            catch (IOException e) {
                throw new IllegalStateException("cannot open or create ZIP BHive " + uri, e);
            }
            relRoot = this.zipFs.getPath("/", new String[0]);
            this.auditor = auditor == null ? new NullAuditor() : auditor;
        } else {
            relRoot = Paths.get(uri);
            this.zipFs = null;
            this.auditor = auditor == null ? new RollingFileAuditor(relRoot.resolve("logs")) : auditor;
        }
        Path objRoot = relRoot.resolve("objects");
        try {
            this.objTmp = this.zipFs == null ? relRoot.resolve("tmp") : Files.createTempDirectory("objdb-", new FileAttribute[0]);
            this.markerTmp = this.zipFs == null ? relRoot.resolve("markers") : this.objTmp.resolve("markers");
            PathHelper.mkdirs(this.markerTmp);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temporary directory for zipped BHive", e);
        }
        this.objects = new ObjectDatabase(objRoot, this.objTmp, reporter);
        this.manifests = new ManifestDatabase(relRoot.resolve("manifests"));
        this.reporter = reporter;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public Auditor getAuditor() {
        return this.auditor;
    }

    public <T> T execute(Operation<T> op) {
        try {
            Object v;
            block12: {
                Timer.Context timer = Metrics.getMetric(Metrics.MetricGroup.HIVE).timer(op.getClass().getSimpleName()).time();
                try {
                    ((Operation)op).initOperation(this);
                    if (op.getClass().getAnnotation(ReadOnlyOperation.class) == null) {
                        this.auditor.audit(AuditRecord.Builder.fromSystem().setWhat(op.getClass().getSimpleName()).addParameters(new AuditParameterExtractor().extract(op)).build());
                    }
                    v = op.call();
                    if (timer == null) break block12;
                    timer.close();
                }
                catch (Throwable throwable) {
                    try {
                        if (timer != null) {
                            try {
                                timer.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.auditor.audit(AuditRecord.Builder.fromSystem().setWhat(op.getClass().getSimpleName()).setSeverity(AuditRecord.Severity.ERROR).addParameters(new AuditParameterExtractor().extract(op)).setMessage(ExceptionHelper.mapExceptionCausesToReason(e)).build());
                        throw new IllegalStateException("operation on hive " + this.uri + " failed", e);
                    }
                }
            }
            return (T)v;
        }
        finally {
            ((Operation)op).closeOperation();
        }
    }

    @Override
    public void close() {
        if (this.zipFs != null) {
            try {
                this.zipFs.close();
            }
            catch (IOException e) {
                log.warn("Cannot close ZIP FS: {}", (Object)this.uri, (Object)e);
            }
            PathHelper.deleteRecursive(this.objTmp);
        }
        this.auditor.close();
    }

    public static abstract class Operation<T>
    implements Callable<T>,
    BHiveExecution {
        private BHive hive;
        private ObjectManager mgr;
        private ExecutorService fileOps;
        private static final AtomicInteger fileOpNum = new AtomicInteger(0);

        private final void initOperation(BHive hive) {
            this.hive = hive;
            this.fileOps = Executors.newFixedThreadPool(hive.parallelism, new NamedDaemonThreadFactory(() -> "File-OPS-" + fileOpNum.incrementAndGet()));
            this.mgr = new ObjectManager(hive.objects, hive.manifests, hive.reporter, this.fileOps);
        }

        private final void closeOperation() {
            this.fileOps.shutdownNow();
            this.hive = null;
            this.mgr = null;
        }

        protected ObjectManager getObjectManager() {
            return this.mgr;
        }

        protected ManifestDatabase getManifestDatabase() {
            return this.hive.manifests;
        }

        protected Path getMarkerRoot() {
            return this.hive.markerTmp;
        }

        protected ActivityReporter getActivityReporter() {
            return this.hive.reporter;
        }

        protected Future<?> submitFileOperation(Runnable op) {
            return this.fileOps.submit(() -> {
                try {
                    op.run();
                }
                catch (Throwable t) {
                    JerseyBroadcastingActivityReporter.resetThread();
                    throw t;
                }
            });
        }

        @Override
        public <X> X execute(Operation<X> other) {
            return this.hive.execute(other);
        }
    }
}

