/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.audit;

import io.bdeploy.bhive.BHive;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditParameterExtractor {
    private static final Logger log = LoggerFactory.getLogger(AuditParameterExtractor.class);

    public Map<String, String> extract(BHive.Operation<?> op) {
        Class<?> clazz = op.getClass();
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Field field : clazz.getDeclaredFields()) {
            NoAudit na = field.getAnnotation(NoAudit.class);
            if (na != null || Modifier.isStatic(field.getModifiers())) {
                if (!log.isTraceEnabled()) continue;
                log.trace("Skipping audit of {}", (Object)field);
                continue;
            }
            Function converter = null;
            AuditStrategy strategy = AuditStrategy.TO_STRING;
            AuditWith with = field.getAnnotation(AuditWith.class);
            if (with != null) {
                strategy = with.value();
            }
            if (converter == null) {
                converter = strategy.converter;
            }
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(op);
                if (fieldValue == null) continue;
                result.put(field.getName(), (String)converter.apply(fieldValue));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                log.debug("Cannot read value of {}", (Object)field, (Object)e);
            }
        }
        return result;
    }

    public static enum AuditStrategy {
        TO_STRING(Object::toString),
        COLLECTION_SIZE(x -> Integer.toString(((Collection)x).size())),
        COLLECTION_PEEK(x -> {
            ArrayList<String> items = new ArrayList<String>();
            if (x instanceof Collection) {
                Collection coll = (Collection)x;
                coll.stream().limit(3L).map(Object::toString).forEach(items::add);
                if (coll.size() > 3) {
                    items.add("...");
                }
            } else if (x instanceof Map) {
                Map m3 = (Map)x;
                m3.entrySet().stream().limit(3L).map(Object::toString).forEach(items::add);
                if (m3.size() > 3) {
                    items.add("...");
                }
            }
            return ((Object)items).toString();
        });

        private final Function<Object, String> converter;

        private AuditStrategy(Function<Object, String> converter) {
            this.converter = converter;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface AuditWith {
        public AuditStrategy value() default AuditStrategy.TO_STRING;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface NoAudit {
    }
}

