/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.remote.FetchOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolDefaultVerbose;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.UnitHelper;
import io.bdeploy.jersey.cli.RemoteServiceTool;
import java.nio.file.Paths;

@Configuration.Help(value="Fetch Manifest(s) from a remote BHive instance.")
@ToolBase.CliTool.CliName(value="fetch")
@ToolDefaultVerbose(value=true)
public class FetchTool
extends RemoteServiceTool<FetchConfig> {
    public FetchTool() {
        super(FetchConfig.class);
    }

    @Override
    protected void run(FetchConfig config, RemoteService svc) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        try (BHive hive = new BHive(Paths.get(config.hive(), new String[0]).toUri(), this.getActivityReporter());){
            FetchOperation op = ((FetchOperation)new FetchOperation().setRemote(svc)).setHiveName(config.source());
            for (String m3 : config.manifest()) {
                Manifest.Key key = Manifest.Key.parse(m3);
                op.addManifest(key);
            }
            TransferStatistics stats = hive.execute(op);
            this.out().println(String.format("Fetched %1$d manifests. %2$d of %3$d trees reused, %4$d objects received (%5$s)", stats.sumManifests, stats.sumTrees - stats.sumMissingTrees, stats.sumTrees, stats.sumMissingObjects, UnitHelper.formatFileSize(stats.transferSize)));
        }
        catch (Exception e) {
            this.out().println("Cannot fetch from remote");
            e.printStackTrace(this.out());
        }
    }

    public static @interface FetchConfig {
        @Configuration.Help(value="The local BHive")
        @Configuration.EnvironmentFallback(value="BHIVE")
        public String hive();

        @Configuration.Help(value="The remote hive name if not default")
        @Configuration.EnvironmentFallback(value="REMOTE_BHIVE")
        public String source();

        @Configuration.Help(value="Manifest(s) to push. May appear multiple times. Format is 'name:tag'")
        public String[] manifest() default {};
    }
}

