/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.op.FsckOperation;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolBase;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

@Configuration.Help(value="Check manifest and object consistency on a BHive instance. Broken objects will be removed.")
@ToolBase.CliTool.CliName(value="fsck")
public class FsckTool
extends ToolBase.ConfiguredCliTool<FsckConfig> {
    public FsckTool() {
        super(FsckConfig.class);
    }

    @Override
    protected void run(FsckConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        try (BHive hive = new BHive(Paths.get(config.hive(), new String[0]).toUri(), this.getActivityReporter());){
            FsckOperation op = new FsckOperation().setRepair(config.repair());
            Arrays.stream(config.manifest()).map(Manifest.Key::parse).forEach(op::addManifest);
            List<ElementView> broken = hive.execute(op);
            broken.stream().forEach(x -> this.out().println("PROBLEMATIC OBJECT: " + x));
            if (broken.isEmpty()) {
                this.out().println("Check OK");
            }
        }
    }

    public static @interface FsckConfig {
        @Configuration.Help(value="The local BHive")
        @Configuration.EnvironmentFallback(value="BHIVE")
        public String hive();

        @Configuration.Help(value="Manifest(s) to check. May appear multiple times. Format is 'name:tag'. If not present, all manifests are checked.")
        public String[] manifest() default {};

        @Configuration.Help(value="Repair the Hive by removing any damaged objects", arg=false)
        public boolean repair() default false;
    }
}

