/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.ImportOperation;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cfg.ExistingPathValidator;
import io.bdeploy.common.cli.ToolBase;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.TreeMap;

@Configuration.Help(value="Imports a source directory into a BHive")
@ToolBase.CliTool.CliName(value="import")
public class ImportTool
extends ToolBase.ConfiguredCliTool<ImportConfig> {
    public ImportTool() {
        super(ImportConfig.class);
    }

    @Override
    protected void run(ImportConfig config) {
        this.helpAndFailIfMissing(config.source(), "Missing --source");
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        this.helpAndFailIfMissing(config.manifest(), "Missing --manifest");
        Path source = Paths.get(config.source(), new String[0]);
        Path target = Paths.get(config.hive(), new String[0]);
        if (!Files.isDirectory(source, new LinkOption[0])) {
            this.helpAndFail("Source path must be a directory (" + source + ")");
        }
        TreeMap<String, String> labels = new TreeMap<String, String>();
        for (String lbl : config.label()) {
            if (!lbl.contains(":")) {
                this.helpAndFail("Label must use ':' as key/value separator (" + lbl + ")");
            }
            int idefix = lbl.indexOf(58);
            String k = lbl.substring(0, idefix);
            String v = lbl.substring(idefix + 1);
            labels.put(k, v);
        }
        try (BHive hive = new BHive(target.toUri(), this.getActivityReporter());){
            hive.setParallelism(config.jobs());
            ImportOperation op = new ImportOperation().setSourcePath(source).setManifest(Manifest.Key.parse(config.manifest()));
            labels.forEach(op::addLabel);
            hive.execute(op);
        }
    }

    public static @interface ImportConfig {
        @Configuration.Help(value="The path to the directory to import")
        @Configuration.Validator(value=ExistingPathValidator.class)
        public String source();

        @Configuration.Help(value="The target BHive to import into")
        @Configuration.EnvironmentFallback(value="BHIVE")
        public String hive();

        @Configuration.Help(value="Manifest(s) to create. Format is 'name:tag'")
        public String manifest();

        @Configuration.Help(value="Can appear multiple times. ':' separated key value pair of label to add")
        public String[] label() default {};

        @Configuration.Help(value="Parallelism - how many threads to use to import. Default: 4")
        public int jobs() default 4;
    }
}

