/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.CopyOperation;
import io.bdeploy.bhive.op.ManifestDeleteOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.bhive.remote.RemoteBHive;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.jersey.cli.RemoteServiceTool;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.ws.rs.core.UriBuilder;

@Configuration.Help(value="Query and manipulate manifests in the given BHive")
@ToolBase.CliTool.CliName(value="manifest")
public class ManifestTool
extends RemoteServiceTool<ManifestConfig> {
    public ManifestTool() {
        super(ManifestConfig.class);
    }

    @Override
    protected void run(ManifestConfig config, @RemoteServiceTool.RemoteOptional RemoteService svc) {
        if (svc == null) {
            this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        }
        if (!config.list() && !config.delete() && config.saveTo() == null) {
            this.helpAndFail("Nothing to do, please give more options");
        }
        if (config.hive() != null) {
            this.runOnLocalHive(config);
        } else {
            this.runOnRemoteHive(config, svc);
        }
    }

    private void runOnRemoteHive(ManifestConfig config, RemoteService svc) {
        if (config.delete()) {
            throw new UnsupportedOperationException("Remote manifest deletion not supported.");
        }
        if (config.saveTo() != null) {
            throw new UnsupportedOperationException("Remote manifest saving not supported.");
        }
        try (RemoteBHive rh = RemoteBHive.forService(svc, config.source(), this.getActivityReporter());){
            if (config.list()) {
                SortedMap<Manifest.Key, ObjectId> mfs = rh.getManifestInventory(new String[0]);
                if (mfs.isEmpty()) {
                    this.out().println("No manifests found");
                } else {
                    mfs.entrySet().stream().filter(e -> this.matches((Manifest.Key)e.getKey(), config)).forEach(e -> this.out().println(String.format("%1$-70s %2$s", e.getKey(), e.getValue())));
                }
            }
        }
    }

    private void runOnLocalHive(ManifestConfig config) {
        try (BHive hive = new BHive(Paths.get(config.hive(), new String[0]).toUri(), this.getActivityReporter());){
            if (config.list()) {
                SortedSet<Manifest.Key> manifests = hive.execute(new ManifestListOperation());
                if (manifests.isEmpty()) {
                    this.out().println("No manifests found");
                } else {
                    manifests.stream().filter(x -> this.matches((Manifest.Key)x, config)).forEach(e -> {
                        Manifest m3 = hive.execute(new ManifestLoadOperation().setManifest((Manifest.Key)e));
                        this.out().println(String.format("%1$-70s %2$s", e, m3.getRoot()));
                    });
                }
            }
            if (config.delete()) {
                this.helpAndFailIfMissing(config.manifest(), "Missing --manifest");
                Manifest.Key manifest = Manifest.Key.parse(config.manifest());
                hive.execute(new ManifestDeleteOperation().setToDelete(manifest));
            }
            if (config.saveTo() != null) {
                this.doSaveTo(config, hive);
            }
        }
    }

    private void doSaveTo(ManifestConfig config, BHive hive) {
        this.helpAndFailIfMissing(config.manifest(), "Missing --manifest");
        Manifest.Key manifest = Manifest.Key.parse(config.manifest());
        Path tmpFile = null;
        try {
            tmpFile = Files.createTempDirectory("bdeploy-", new FileAttribute[0]);
            ObjectListOperation scan = new ObjectListOperation();
            scan.addManifest(manifest);
            SortedSet<ObjectId> objectIds = hive.execute(scan);
            URI targetUri = UriBuilder.fromUri("jar:" + Paths.get(config.saveTo(), new String[0]).toUri()).build(new Object[0]);
            try (BHive zipHive = new BHive(targetUri, new ActivityReporter.Null());){
                CopyOperation op = new CopyOperation().setDestinationHive(zipHive);
                op.addManifest(manifest);
                objectIds.forEach(op::addObject);
                hive.execute(op);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to save manifest", ex);
        }
        finally {
            if (tmpFile != null) {
                PathHelper.deleteRecursive(tmpFile);
            }
        }
    }

    private boolean matches(Manifest.Key x, ManifestConfig config) {
        if (config.manifest().isEmpty()) {
            return true;
        }
        if (!config.manifest().contains(":") && !x.getName().equals(config.manifest())) {
            return false;
        }
        return Manifest.Key.parse(config.manifest()).equals(x);
    }

    public static @interface ManifestConfig {
        @Configuration.Help(value="The BHive to use. Alternatively use --remote.")
        @Configuration.EnvironmentFallback(value="BHIVE")
        public String hive();

        @Configuration.Help(value="List available manifests", arg=false)
        public boolean list() default false;

        @Configuration.Help(value="Delete a given manifest", arg=false)
        public boolean delete() default false;

        @Configuration.Help(value="The name of the hive on the remote server if going remote")
        public String source();

        @Configuration.Help(value="Manifest(s) to manipulate/list. Format is 'name:tag'. Name without tag is supported to list tags of a given name.")
        public String manifest() default "";

        @Configuration.Help(value="Path to a ZIP file where the manifest and all its dependencies should be saved to.")
        public String saveTo();
    }
}

