/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.PruneOperation;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.util.UnitHelper;
import java.nio.file.Paths;
import java.util.SortedMap;
import java.util.stream.Collectors;

@Configuration.Help(value="Prune any unreferenced objects from the given BHive")
@ToolBase.CliTool.CliName(value="prune")
public class PruneTool
extends ToolBase.ConfiguredCliTool<PruneConfig> {
    public PruneTool() {
        super(PruneConfig.class);
    }

    @Override
    protected void run(PruneConfig config) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        try (BHive hive = new BHive(Paths.get(config.hive(), new String[0]).toUri(), this.getActivityReporter());){
            SortedMap<ObjectId, Long> result = hive.execute(new PruneOperation());
            if (config.verbose()) {
                result.forEach((k, v) -> this.out().println(String.format("%1$s %2$s", k, UnitHelper.formatFileSize(v))));
            }
            long sum = result.values().stream().collect(Collectors.summarizingLong(x -> x)).getSum();
            this.out().println(String.format("Removed %1$d objects (%2$s).", result.size(), UnitHelper.formatFileSize(sum)));
        }
    }

    public static @interface PruneConfig {
        @Configuration.Help(value="The BHive to use")
        @Configuration.EnvironmentFallback(value="BHIVE")
        public String hive();

        @Configuration.Help(value="List details about removed objects", arg=false)
        public boolean verbose() default false;
    }
}

