/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.cli;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.op.remote.PushOperation;
import io.bdeploy.bhive.op.remote.TransferStatistics;
import io.bdeploy.common.cfg.Configuration;
import io.bdeploy.common.cli.ToolBase;
import io.bdeploy.common.cli.ToolDefaultVerbose;
import io.bdeploy.common.security.RemoteService;
import io.bdeploy.common.util.UnitHelper;
import io.bdeploy.jersey.cli.RemoteServiceTool;
import java.nio.file.Paths;

@Configuration.Help(value="Push Manifest(s) to a remote BHive instance.")
@ToolBase.CliTool.CliName(value="push")
@ToolDefaultVerbose(value=true)
public class PushTool
extends RemoteServiceTool<PushConfig> {
    public PushTool() {
        super(PushConfig.class);
    }

    @Override
    protected void run(PushConfig config, RemoteService svc) {
        this.helpAndFailIfMissing(config.hive(), "Missing --hive");
        this.helpAndFailIfMissing(config.target(), "Missing --target");
        try (BHive hive = new BHive(Paths.get(config.hive(), new String[0]).toUri(), this.getActivityReporter());){
            PushOperation op = ((PushOperation)new PushOperation().setRemote(svc)).setHiveName(config.target());
            for (String m3 : config.manifest()) {
                Manifest.Key key = Manifest.Key.parse(m3);
                op.addManifest(key);
            }
            TransferStatistics stats = hive.execute(op);
            this.out().println(String.format("Pushed %1$d manifests. %2$d of %3$d trees reused, %4$d objects sent (%5$s)", stats.sumManifests, stats.sumTrees - stats.sumMissingTrees, stats.sumTrees, stats.sumMissingObjects, UnitHelper.formatFileSize(stats.transferSize)));
        }
    }

    public static @interface PushConfig {
        @Configuration.Help(value="The local BHive")
        @Configuration.EnvironmentFallback(value="BHIVE")
        public String hive();

        @Configuration.Help(value="The remote hive name. Set to 'default' to push to the 'default' hive on the remote.")
        @Configuration.EnvironmentFallback(value="REMOTE_BHIVE")
        public String target();

        @Configuration.Help(value="Manifest(s) to push. May appear multiple times. Format is 'name:tag'")
        public String[] manifest() default {};
    }
}

