/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.meta;

import io.bdeploy.bhive.BHiveExecution;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.op.ImportObjectOperation;
import io.bdeploy.bhive.op.InsertArtificialTreeOperation;
import io.bdeploy.bhive.op.InsertManifestOperation;
import io.bdeploy.bhive.op.ManifestDeleteOldByIdOperation;
import io.bdeploy.bhive.op.ManifestExistsOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestLoadOperation;
import io.bdeploy.bhive.op.ManifestMaxIdOperation;
import io.bdeploy.bhive.op.TreeEntryLoadOperation;
import io.bdeploy.bhive.op.TreeLoadOperation;
import io.bdeploy.bhive.util.StorageHelper;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaManifest<T> {
    private static final Logger log = LoggerFactory.getLogger(MetaManifest.class);
    public static final String META_PREFIX = "._meta/";
    private static final String META_DEFTAG = "/._meta";
    private static final int META_HIST_SIZE = 2;
    private final Manifest.Key parent;
    private final String metaName;
    private final Class<T> metaClazz;

    public MetaManifest(Manifest.Key parent, boolean useParentTag, Class<T> metaClazz) {
        this.parent = parent;
        this.metaName = META_PREFIX + parent.getName() + "/" + metaClazz.getSimpleName() + (useParentTag ? "/" + parent.getTag() : META_DEFTAG);
        this.metaClazz = metaClazz;
    }

    public static boolean isMetaManifest(Manifest.Key meta) {
        return meta.getName().startsWith(META_PREFIX);
    }

    public static boolean isParentAlive(Manifest.Key meta, BHiveExecution hive, SortedSet<Manifest.Key> ignore) {
        if (!MetaManifest.isMetaManifest(meta)) {
            throw new IllegalArgumentException("Given manifest is not a meta manifest: " + meta);
        }
        String mfName = meta.getName().substring(META_PREFIX.length(), meta.getName().lastIndexOf(47));
        mfName = mfName.substring(0, mfName.lastIndexOf(47));
        if (meta.getName().endsWith(META_DEFTAG)) {
            SortedSet<Manifest.Key> allKeys = hive.execute(new ManifestListOperation().setManifestName(mfName));
            return allKeys.stream().filter(x -> !ignore.contains(x)).count() > 0L;
        }
        String tag = meta.getName().substring(meta.getName().lastIndexOf(47) + 1);
        Manifest.Key key = new Manifest.Key(mfName, tag);
        if (ignore.contains(key)) {
            return false;
        }
        return hive.execute(new ManifestExistsOperation().setManifest(key));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T read(BHiveExecution source) {
        Optional<Long> id = source.execute(new ManifestMaxIdOperation().setManifestName(this.metaName));
        if (!id.isPresent()) {
            return null;
        }
        Manifest.Key key = new Manifest.Key(this.metaName, id.get().toString());
        Manifest mf = source.execute(new ManifestLoadOperation().setManifest(key));
        try (InputStream is = source.execute(new TreeEntryLoadOperation().setRootTree(mf.getRoot()).setRelativePath(this.metaFileName()));){
            T t = StorageHelper.fromStream(is, this.metaClazz);
            return t;
        }
        catch (Exception e) {
            log.debug("Cannot read {} for {}", this.metaFileName(), this.parent, e);
            return null;
        }
    }

    public Manifest.Key write(BHiveExecution target, T meta) {
        String targetTag = "1";
        Optional<Long> id = target.execute(new ManifestMaxIdOperation().setManifestName(this.metaName));
        Tree oldTree = null;
        if (id.isPresent()) {
            targetTag = Long.toString(id.get() + 1L);
            Manifest mf = target.execute(new ManifestLoadOperation().setManifest(new Manifest.Key(this.metaName, id.get().toString())));
            oldTree = target.execute(new TreeLoadOperation().setTree(mf.getRoot()));
        }
        Manifest.Key targetKey = new Manifest.Key(this.metaName, targetTag);
        Manifest.Builder newMf = new Manifest.Builder(targetKey);
        Tree.Builder newTree = new Tree.Builder();
        String metaFileName = this.metaFileName();
        if (meta != null) {
            ObjectId oid = target.execute(new ImportObjectOperation().setData(StorageHelper.toRawBytes(meta)));
            newTree.add(new Tree.Key(metaFileName, Tree.EntryType.BLOB), oid);
        }
        if (oldTree != null) {
            for (Map.Entry entry : oldTree.getChildren().entrySet()) {
                if (((Tree.Key)entry.getKey()).getName().equals(metaFileName)) continue;
                newTree.add((Tree.Key)entry.getKey(), (ObjectId)entry.getValue());
            }
        }
        ObjectId newTreeId = target.execute(new InsertArtificialTreeOperation().setTree(newTree));
        target.execute(new InsertManifestOperation().addManifest(newMf.setRoot(newTreeId).build(target)));
        target.execute(new ManifestDeleteOldByIdOperation().setAmountToKeep(2).setToDelete(this.metaName));
        return targetKey;
    }

    public Manifest.Key remove(BHiveExecution target) {
        return this.write(target, null);
    }

    private String metaFileName() {
        return this.metaClazz.getSimpleName() + ".json";
    }
}

