/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.bdeploy.common.util.Hex;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;

public class ObjectId
implements Serializable,
Comparable<ObjectId> {
    private static final long serialVersionUID = 1L;
    private static final Pattern ID_PATTERN = Pattern.compile("[0-9a-f]{40}");
    private final String id;

    private ObjectId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @JsonCreator
    public static ObjectId parse(@JsonProperty(value="id") String id) {
        if (ID_PATTERN.matcher(id).matches()) {
            return new ObjectId(id);
        }
        return null;
    }

    public static ObjectId create(byte[] data, int offset, int len) {
        MessageDigest digest = ObjectId.createDigest();
        digest.update(data, offset, len);
        return new ObjectId(Hex.bytesToHex(digest.digest()));
    }

    public static ObjectId createByCopy(InputStream source, Path target) throws IOException {
        MessageDigest digest = ObjectId.createDigest();
        try (OutputStream os = Files.newOutputStream(target, new OpenOption[0]);){
            byte[] buf = new byte[4096];
            int read = 0;
            while ((read = source.read(buf)) > 0) {
                digest.update(buf, 0, read);
                os.write(buf, 0, read);
            }
        }
        return new ObjectId(Hex.bytesToHex(digest.digest()));
    }

    public static ObjectId createFromStreamNoCopy(InputStream source) throws IOException {
        MessageDigest digest = ObjectId.createDigest();
        byte[] buf = new byte[4096];
        int read = 0;
        while ((read = source.read(buf)) > 0) {
            digest.update(buf, 0, read);
        }
        return new ObjectId(Hex.bytesToHex(digest.digest()));
    }

    public String toString() {
        return this.id;
    }

    private static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 support is required", e);
        }
    }

    @Override
    public int compareTo(ObjectId o) {
        return this.id.compareTo(o.id);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectId other = (ObjectId)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

