/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.model;

import com.google.common.collect.MoreCollectors;
import io.bdeploy.bhive.model.ObjectId;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Tree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SortedMap<Key, ObjectId> children = new TreeMap<Key, ObjectId>();

    public Map<Key, ObjectId> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public Map.Entry<Key, ObjectId> getNamedEntry(String name) {
        return (Map.Entry)this.children.entrySet().stream().filter(e -> ((Key)e.getKey()).name.equals(name)).collect(MoreCollectors.onlyElement());
    }

    public static final class Key
    implements Serializable,
    Comparable<Key> {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final EntryType type;

        public Key(String name, EntryType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public EntryType getType() {
            return this.type;
        }

        @Override
        public int compareTo(Key o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "[" + (Object)((Object)this.type) + "] " + this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.type == other.type;
        }
    }

    public static final class Builder {
        private final Map<Key, ObjectId> children = new TreeMap<Key, ObjectId>();

        public synchronized Builder add(Key key, ObjectId id) {
            if (this.children.containsKey(key)) {
                throw new IllegalArgumentException("duplicate entry in tree: " + key);
            }
            this.children.put(key, id);
            return this;
        }

        public synchronized Tree build() {
            Tree t = new Tree();
            t.children.putAll(this.children);
            return t;
        }

        public String toString() {
            return "Tree(" + this.children.size() + ")";
        }
    }

    public static enum EntryType {
        BLOB,
        TREE,
        MANIFEST;

    }
}

