/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;

public abstract class LockableDatabase {
    private final File lockFile;

    public LockableDatabase(Path root) {
        this.lockFile = LockableDatabase.determineLockFile(root);
    }

    private static File determineLockFile(Path root) {
        try {
            return root.resolve(".dblock").toFile();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    protected synchronized void locked(LockedOperation toLock) {
        try {
            if (this.lockFile == null) {
                toLock.run();
                return;
            }
            try (RandomAccessFile raf = new RandomAccessFile(this.lockFile, "rw");
                 FileChannel channel = raf.getChannel();
                 FileLock lock = channel.lock();){
                toLock.run();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("locked execution failed", e);
        }
    }

    @FunctionalInterface
    protected static interface LockedOperation {
        public void run() throws Exception;
    }
}

