/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.LockableDatabase;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;

public class ManifestDatabase
extends LockableDatabase {
    private final Path root;
    private final Cache<Manifest.Key, Manifest> manifestCache = CacheBuilder.newBuilder().maximumSize(2500L).build();

    public ManifestDatabase(Path root) {
        super(root);
        this.root = root;
        if (!Files.exists(root, new LinkOption[0])) {
            PathHelper.mkdirs(root);
        }
    }

    private Path getPathForKey(Manifest.Key key) {
        return this.root.resolve(key.getName()).resolve(key.getTag());
    }

    public boolean hasManifest(Manifest.Key key) {
        return Files.exists(this.getPathForKey(key), new LinkOption[0]);
    }

    public void addManifest(Manifest manifest) {
        this.locked(() -> {
            if (this.hasManifest(manifest.getKey())) {
                throw new IllegalArgumentException("Manifest " + manifest.getKey() + " already present.");
            }
            Path pathForKey = this.getPathForKey(manifest.getKey());
            PathHelper.mkdirs(pathForKey.getParent());
            Files.write(pathForKey, StorageHelper.toRawBytes(manifest), new OpenOption[0]);
            this.manifestCache.put(manifest.getKey(), manifest);
        });
    }

    public void removeManifest(Manifest.Key key) {
        this.locked(() -> {
            Files.deleteIfExists(this.getPathForKey(key));
            this.manifestCache.invalidate(key);
        });
    }

    public SortedSet<Manifest.Key> getAllManifests() {
        return this.collectManifests(this.root);
    }

    private SortedSet<Manifest.Key> collectManifests(Path scanRoot) {
        TreeSet<Manifest.Key> result = new TreeSet<Manifest.Key>();
        try {
            if (!Files.isDirectory(scanRoot, new LinkOption[0])) {
                return result;
            }
            try (Stream<Path> walk = Files.walk(scanRoot, new FileVisitOption[0]);){
                walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(f -> {
                    Path rel = this.root.relativize((Path)f);
                    if (rel.getParent() == null) {
                        return;
                    }
                    String manifestName = rel.getParent().toString().replace('\\', '/');
                    String manifestTag = rel.getFileName().toString();
                    result.add(new Manifest.Key(manifestName, manifestTag));
                });
            }
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading manifest database", e);
        }
    }

    public SortedSet<Manifest.Key> getAllForName(String name) {
        if (name.contains(":")) {
            TreeSet<Manifest.Key> result = new TreeSet<Manifest.Key>();
            Manifest.Key key = Manifest.Key.parse(name);
            if (this.hasManifest(key)) {
                result.add(key);
            }
            return result;
        }
        Path namedRoot = this.root.resolve(name);
        return this.collectManifests(namedRoot);
    }

    public Manifest getManifest(Manifest.Key key) {
        try {
            return this.manifestCache.get(key, () -> {
                Manifest manifest;
                block9: {
                    if (!this.hasManifest(key)) {
                        throw new IllegalArgumentException("Don't have manifest " + key);
                    }
                    InputStream is = Files.newInputStream(this.getPathForKey(key), new OpenOption[0]);
                    try {
                        manifest = StorageHelper.fromStream(is, Manifest.class);
                        if (is == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Cannot read manifest " + key, e);
                        }
                    }
                    is.close();
                }
                return manifest;
            });
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot load manifest into cache: " + key, e);
        }
    }
}

