/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.ObjectDatabase;
import io.bdeploy.bhive.objects.ObjectWriter;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerDatabase
extends ObjectDatabase {
    private static final Logger log = LoggerFactory.getLogger(MarkerDatabase.class);
    private static final String LOCK_FILE = ".lock";

    public MarkerDatabase(Path root, ActivityReporter reporter) {
        super(root, root.resolve("tmp"), reporter);
    }

    public void addMarker(ObjectId id) {
        Path markerFile = this.getObjectFile(id);
        PathHelper.mkdirs(markerFile.getParent());
        try {
            Files.createFile(markerFile, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot add marker for " + id, e);
        }
    }

    @Override
    public InputStream getStream(ObjectId id) throws IOException {
        throw new UnsupportedOperationException("Marker-only Database");
    }

    @Override
    protected ObjectId internalAddObject(ObjectWriter writer) throws IOException {
        throw new UnsupportedOperationException("Marker-only Database");
    }

    @Override
    public void removeObject(ObjectId id) {
        throw new UnsupportedOperationException("Marker-only Database");
    }

    public static void lockRoot(Path root) {
        boolean infoWritten = false;
        for (int i = 0; i < 100000; ++i) {
            try {
                Files.createFile(root.resolve(LOCK_FILE), new FileAttribute[0]).toFile().deleteOnExit();
                return;
            }
            catch (FileAlreadyExistsException e) {
                if (!infoWritten) {
                    log.info("Waiting for " + root);
                    infoWritten = true;
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot lock root", e);
            }
        }
        throw new IllegalStateException("Retries exceeded or interrupted, failed to lock marker root");
    }

    public static void waitRootLock(Path root) {
        Path lockFile = root.resolve(LOCK_FILE);
        for (int i = 0; i < 100000; ++i) {
            if (Files.exists(lockFile, new LinkOption[0])) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            return;
        }
        throw new IllegalStateException("Retries exceeded or interrupted, failed to wait for marker root lock");
    }

    public static void unlockRoot(Path root) {
        PathHelper.deleteRecursive(root.resolve(LOCK_FILE));
    }
}

