/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.LockableDatabase;
import io.bdeploy.bhive.objects.ObjectWriter;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.PathHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ObjectDatabase
extends LockableDatabase {
    static final long MAX_BUFFER_SIZE = 0xA00000L;
    private final Path root;
    private final Path tmp;
    private final ActivityReporter reporter;

    public ObjectDatabase(Path root, Path tmp, ActivityReporter reporter) {
        super(root);
        this.root = root;
        this.tmp = tmp;
        this.reporter = reporter;
        if (!Files.exists(root, new LinkOption[0])) {
            PathHelper.mkdirs(root);
        }
        if (!Files.exists(tmp, new LinkOption[0])) {
            PathHelper.mkdirs(tmp);
        }
    }

    public InputStream getStream(ObjectId id) throws IOException {
        if (!this.hasObject(id)) {
            throw new IllegalStateException("Missing object: " + id);
        }
        return Files.newInputStream(this.getObjectFile(id), new OpenOption[0]);
    }

    public boolean hasObject(ObjectId id) {
        Path path = this.getObjectFile(id);
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return this.getObjectFile(id).toFile().exists();
        }
        return Files.exists(this.getObjectFile(id), new LinkOption[0]);
    }

    public ObjectId addObject(Path file) throws IOException {
        long size = Files.size(file);
        if (size >= 0xA00000L) {
            try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                ObjectId objectId = this.addObject(is);
                return objectId;
            }
        }
        byte[] bytes = Files.readAllBytes(file);
        return this.addObject(bytes);
    }

    public ObjectId addObject(byte[] bytes) throws IOException {
        return this.internalAddObject(p -> {
            Files.write(p, bytes, new OpenOption[0]);
            return ObjectId.create(bytes, 0, bytes.length);
        });
    }

    public ObjectId addObject(InputStream stream) throws IOException {
        return this.internalAddObject(p -> ObjectId.createByCopy(stream, p));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectId internalAddObject(ObjectWriter writer) throws IOException {
        Path tmpFile = Files.createTempFile(this.tmp, "obj", ".tmp", new FileAttribute[0]);
        try {
            ObjectId id = writer.write(tmpFile);
            Path target = this.getObjectFile(id);
            this.locked(() -> {
                if (this.hasObject(id)) {
                    return;
                }
                PathHelper.mkdirs(target.getParent());
                Files.move(tmpFile, target, new CopyOption[0]);
            });
            ObjectId objectId = id;
            return objectId;
        }
        finally {
            Files.deleteIfExists(tmpFile);
        }
    }

    public boolean checkObject(ObjectId id) throws IOException {
        try (InputStream is = this.getStream(id);){
            ObjectId newId = ObjectId.createFromStreamNoCopy(is);
            boolean bl = newId.equals(id);
            return bl;
        }
    }

    public void removeObject(ObjectId id) {
        if (!this.hasObject(id)) {
            return;
        }
        Path file = this.getObjectFile(id);
        this.locked(() -> Files.delete(file));
    }

    public Path getObjectFile(ObjectId id) {
        String rawId = id.getId();
        String l1 = rawId.substring(0, 2);
        String l2 = rawId.substring(2, 4);
        return this.root.resolve(this.root.getFileSystem().getPath(l1, l2, rawId));
    }

    public long getObjectSize(ObjectId id) throws IOException {
        return Files.size(this.getObjectFile(id));
    }

    public SortedSet<ObjectId> getAllObjects() throws IOException {
        ActivityReporter.Activity scan = this.reporter.start("Scanning objects...", 0L);
        try {
            SortedSet sortedSet;
            block9: {
                Stream<Path> walk = Files.walk(this.root, new FileVisitOption[0]);
                try {
                    sortedSet = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::getFileName).map(Object::toString).map(ObjectId::parse).filter(Objects::nonNull).peek(e -> scan.workAndCancelIfRequested(1L)).collect(Collectors.toCollection(TreeSet::new));
                    if (walk == null) break block9;
                }
                catch (Throwable throwable) {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                walk.close();
            }
            return sortedSet;
        }
        finally {
            scan.done();
        }
    }
}

