/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoInputStreamWrapper;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.model.Tree;
import io.bdeploy.bhive.objects.DefaultReferenceHandler;
import io.bdeploy.bhive.objects.ManifestDatabase;
import io.bdeploy.bhive.objects.ObjectDatabase;
import io.bdeploy.bhive.objects.ReferenceHandler;
import io.bdeploy.bhive.objects.view.BlobView;
import io.bdeploy.bhive.objects.view.DamagedObjectView;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.MissingObjectView;
import io.bdeploy.bhive.objects.view.SkippedElementView;
import io.bdeploy.bhive.objects.view.TreeView;
import io.bdeploy.bhive.util.StorageHelper;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.FutureHelper;
import io.bdeploy.common.util.PathHelper;
import io.bdeploy.common.util.RuntimeAssert;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Stream;

public class ObjectManager {
    private final ObjectDatabase db;
    private final ManifestDatabase mdb;
    private final ActivityReporter reporter;
    private final ExecutorService fileOps;
    private final Cache<ObjectId, Object> objectCache = CacheBuilder.newBuilder().maximumSize(10000L).build();

    public ObjectManager(ObjectDatabase db, ManifestDatabase mdb, ActivityReporter reporter, ExecutorService fileOps) {
        this.db = db;
        this.mdb = mdb;
        this.reporter = reporter;
        this.fileOps = fileOps;
    }

    public ObjectId importTree(Path location, boolean skipEmpty) {
        ActivityReporter.Activity importing = this.reporter.start("Importing objects...", 0L);
        try {
            ObjectId objectId = this.internalImportTree(location, importing, skipEmpty);
            return objectId;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot import " + location, e);
        }
        finally {
            importing.done();
        }
    }

    private ObjectId internalImportTree(Path location, ActivityReporter.Activity importing, boolean skipEmpty) throws IOException {
        Tree.Builder tree = new Tree.Builder();
        ArrayList filesOnLevel = new ArrayList();
        try (DirectoryStream<Path> list = Files.newDirectoryStream(location);){
            for (Path path : list) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (skipEmpty && PathHelper.isDirEmpty(path)) continue;
                    tree.add(new Tree.Key(path.getFileName().toString(), Tree.EntryType.TREE), this.internalImportTree(path, importing, skipEmpty));
                    continue;
                }
                filesOnLevel.add(this.fileOps.submit(() -> {
                    try {
                        tree.add(new Tree.Key(path.getFileName().toString(), Tree.EntryType.BLOB), this.db.addObject(path));
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("cannot insert object from: " + path, e);
                    }
                    importing.workAndCancelIfRequested(1L);
                }));
            }
        }
        FutureHelper.awaitAll(filesOnLevel);
        importing.workAndCancelIfRequested(1L);
        return this.insertTree(tree.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTree(ObjectId tree, Path location, ReferenceHandler handler) {
        if (handler == null) {
            handler = new DefaultReferenceHandler(this);
        }
        try {
            if (Files.exists(location, new LinkOption[0])) {
                try (Stream<Path> list = Files.list(location);){
                    if (list.findAny().isPresent()) {
                        throw new IllegalStateException("Location must not exist or be empty: " + location);
                    }
                }
            }
            ActivityReporter.Activity exporting = this.reporter.start("Writing objects...", 0L);
            try {
                this.internalExportTree(tree, location, tree, location, exporting, handler);
            }
            finally {
                exporting.done();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot export to " + location, e);
        }
    }

    private void internalExportTree(ObjectId tree, Path topLevel, ObjectId topLevelTree, Path location, ActivityReporter.Activity exporting, ReferenceHandler handler) throws IOException {
        PathHelper.mkdirs(location);
        Tree t = this.loadObject(tree, is -> StorageHelper.fromStream(is, Tree.class));
        ArrayList filesOnLevel = new ArrayList();
        for (Map.Entry<Tree.Key, ObjectId> entry : t.getChildren().entrySet()) {
            ObjectId obj = entry.getValue();
            Tree.Key key = entry.getKey();
            Path child = location.resolve(key.getName());
            switch (key.getType()) {
                case BLOB: {
                    filesOnLevel.add(this.fileOps.submit(() -> {
                        try {
                            this.internalExportBlobByCopy(obj, child);
                        }
                        finally {
                            exporting.workAndCancelIfRequested(1L);
                        }
                    }));
                    break;
                }
                case MANIFEST: {
                    handler.onReference(location, key, this.lookupManifestRef(obj));
                    break;
                }
                case TREE: {
                    this.internalExportTree(obj, topLevel, topLevelTree, child, exporting, handler);
                    break;
                }
            }
        }
        FutureHelper.awaitAll(filesOnLevel);
        exporting.workAndCancelIfRequested(1L);
    }

    private void internalExportBlobByCopy(ObjectId obj, Path child) {
        try (ContentInfoInputStreamWrapper is = new ContentInfoInputStreamWrapper(this.db.getStream(obj), PathHelper.getContentInfoUtil());){
            ObjectId finalId = ObjectId.createByCopy(is, child);
            if (!finalId.equals(obj)) {
                throw new IOException("BLOB corruption: " + obj + " (is " + finalId + "), run FSCK");
            }
            this.setExecutable(child, is.findMatch());
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot export " + obj + " to " + child, ioe);
        }
    }

    private void setExecutable(Path child, ContentInfo hint) throws IOException {
        PosixFileAttributeView view = Files.getFileAttributeView(child, PosixFileAttributeView.class, new LinkOption[0]);
        if (view != null) {
            if ((hint = PathHelper.getContentInfo(child, hint)) == null) {
                return;
            }
            if (PathHelper.isExecutable(hint)) {
                Set<PosixFilePermission> perms = view.readAttributes().permissions();
                perms.add(PosixFilePermission.OWNER_EXECUTE);
                perms.add(PosixFilePermission.GROUP_EXECUTE);
                view.setPermissions(perms);
            }
        }
    }

    public TreeView scan(ObjectId tree, int maxDepth, boolean followReferences) {
        ElementView ev = this.db.hasObject(tree) ? this.scan(tree, Tree.EntryType.TREE, new ArrayDeque<String>(), maxDepth, followReferences) : new DamagedObjectView(tree, Tree.EntryType.TREE, Collections.emptyList());
        if (ev instanceof TreeView) {
            return (TreeView)ev;
        }
        TreeView tv = new TreeView(null, Collections.emptyList());
        tv.addChild(ev);
        return tv;
    }

    private ElementView scan(ObjectId object, Tree.EntryType type, Deque<String> path, int maxDepth, boolean followReferences) {
        if (type != Tree.EntryType.BLOB && path.size() >= maxDepth) {
            return new SkippedElementView(object, path);
        }
        if (!this.db.hasObject(object)) {
            return new MissingObjectView(object, type, path);
        }
        switch (type) {
            case BLOB: {
                return new BlobView(object, path);
            }
            case MANIFEST: {
                Manifest mf = this.lookupManifestRef(object);
                if (mf == null) {
                    return new MissingObjectView(object, type, path);
                }
                ManifestRefView mrs = new ManifestRefView(object, mf.getKey(), mf.getRoot(), path);
                if (!followReferences) {
                    mrs.addChild(new SkippedElementView(mf.getRoot(), path));
                    return mrs;
                }
                if (!this.db.hasObject(mf.getRoot())) {
                    mrs.addChild(new MissingObjectView(mf.getRoot(), Tree.EntryType.TREE, path));
                    return mrs;
                }
                try {
                    Tree mrt = this.loadObject(mf.getRoot(), is -> StorageHelper.fromStream(is, Tree.class));
                    this.scanChildren(mrs, mrt, path, maxDepth, followReferences);
                }
                catch (Exception e) {
                    mrs.addChild(new DamagedObjectView(mf.getRoot(), type, path));
                }
                return mrs;
            }
            case TREE: {
                try {
                    Tree t = this.loadObject(object, is -> StorageHelper.fromStream(is, Tree.class));
                    TreeView ts = new TreeView(object, path);
                    this.scanChildren(ts, t, path, maxDepth, followReferences);
                    return ts;
                }
                catch (Exception e) {
                    return new DamagedObjectView(object, Tree.EntryType.TREE, path);
                }
            }
        }
        throw new IllegalStateException("Unsupported object type: " + (Object)((Object)type));
    }

    private void scanChildren(TreeView container, Tree tree, Deque<String> path, int maxDepth, boolean followReferences) {
        for (Map.Entry<Tree.Key, ObjectId> entry : tree.getChildren().entrySet()) {
            path.addLast(entry.getKey().getName());
            container.addChild(this.scan(entry.getValue(), entry.getKey().getType(), path, maxDepth, followReferences));
            path.removeLast();
        }
    }

    public InputStream getStreamForRelativePath(ObjectId tree, String ... path) throws IOException {
        Tree t = this.loadObject(tree, is -> StorageHelper.fromStream(is, Tree.class));
        if (path.length > 1) {
            ObjectId subTree = this.getSubTreeForName(t, path[0]);
            RuntimeAssert.assertNotNull(subTree, "Cannot find TREE: " + path[0]);
            RuntimeAssert.assertTrue(this.db.hasObject(subTree), "Missing TREE: " + subTree);
            return this.getStreamForRelativePath(subTree, Arrays.copyOfRange(path, 1, path.length));
        }
        ObjectId id = t.getChildren().get(new Tree.Key(path[0], Tree.EntryType.BLOB));
        RuntimeAssert.assertNotNull(id, "Cannot find BLOB: " + path[0]);
        RuntimeAssert.assertTrue(this.db.hasObject(id), "Missing BLOB: " + id);
        return this.db.getStream(id);
    }

    private ObjectId getSubTreeForName(Tree t, String name) {
        return t.getChildren().entrySet().stream().filter(e -> ((Tree.Key)e.getKey()).getName().equals(name)).map(e -> {
            switch (((Tree.Key)e.getKey()).getType()) {
                case MANIFEST: {
                    Manifest m3 = this.lookupManifestRef((ObjectId)e.getValue());
                    return m3.getRoot();
                }
                case TREE: {
                    return (ObjectId)e.getValue();
                }
            }
            throw new IllegalArgumentException(name + " is not a sub-tree");
        }).findAny().orElse(null);
    }

    private Manifest lookupManifestRef(ObjectId manifestRef) {
        Manifest manifest;
        block9: {
            InputStream is = this.db.getStream(manifestRef);
            try {
                Manifest.Key key = StorageHelper.fromStream(is, Manifest.Key.class);
                if (!this.mdb.hasManifest(key)) {
                    throw new IllegalArgumentException("Referenced manifest not found: " + key);
                }
                manifest = this.mdb.getManifest(key);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot lookup manifest reference", e);
                }
            }
            is.close();
        }
        return manifest;
    }

    public ObjectId insertManifestReference(Manifest.Key key) {
        try {
            return this.db.addObject(StorageHelper.toRawBytes(key));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot insert manifest reference", e);
        }
    }

    public ObjectId insertTree(Tree tree) {
        try {
            return this.db.addObject(StorageHelper.toRawBytes(tree));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot insert tree", e);
        }
    }

    public boolean checkObject(ObjectId id, boolean remove) {
        try {
            boolean ok = this.db.checkObject(id);
            if (!ok && remove) {
                this.db.removeObject(id);
            }
            return ok;
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot check object consistency on " + id, e);
        }
    }

    private <T> T loadObject(ObjectId id, Function<InputStream, T> loader) {
        try {
            return (T)this.objectCache.get(id, () -> {
                Object r;
                block8: {
                    InputStream is = this.db.getStream(id);
                    try {
                        r = loader.apply(is);
                        if (is == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException("Cannot load object " + id, e);
                        }
                    }
                    is.close();
                }
                return r;
            });
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Cannot load object into cache: " + id, e);
        }
    }

    public <T> T db(DbCallable<T> c) {
        try {
            return c.call(this.db);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot perform DB operation", e);
        }
    }

    @FunctionalInterface
    public static interface DbCallable<R> {
        public R call(ObjectDatabase var1) throws IOException;
    }
}

