/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects.view;

import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.scanner.TreeVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public class TreeView
extends ElementView {
    private final Map<String, ElementView> children = new TreeMap<String, ElementView>();

    public TreeView(ObjectId treeId, Collection<String> path) {
        super(treeId, path);
    }

    public void addChild(ElementView snapshot) {
        this.children.put(snapshot.getName(), snapshot);
    }

    public Map<String, ElementView> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    public void visit(TreeVisitor scanner) {
        if (scanner.accept(this)) {
            for (Map.Entry<String, ElementView> entry : this.children.entrySet()) {
                ElementView element = entry.getValue();
                if (element instanceof TreeView) {
                    ((TreeView)element).visit(scanner);
                    continue;
                }
                scanner.accept(element);
            }
        }
    }
}

