/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.objects.view.scanner;

import io.bdeploy.bhive.objects.view.BlobView;
import io.bdeploy.bhive.objects.view.DamagedObjectView;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.objects.view.ManifestRefView;
import io.bdeploy.bhive.objects.view.MissingObjectView;
import io.bdeploy.bhive.objects.view.SkippedElementView;
import io.bdeploy.bhive.objects.view.TreeView;
import java.util.function.Consumer;
import java.util.function.Function;

public class TreeVisitor {
    private Consumer<BlobView> blobConsumer;
    private Consumer<DamagedObjectView> damagedConsumer;
    private Consumer<ManifestRefView> manifestConsumer;
    private Consumer<MissingObjectView> missingConsumer;
    private Consumer<SkippedElementView> skippedConsumer;
    private Function<TreeView, Boolean> treeConsumer;

    private TreeVisitor() {
    }

    public boolean accept(ElementView snapshot) {
        boolean visitChildren = true;
        if (snapshot instanceof DamagedObjectView && this.damagedConsumer != null) {
            this.damagedConsumer.accept((DamagedObjectView)snapshot);
        }
        if (snapshot instanceof MissingObjectView && this.missingConsumer != null) {
            this.missingConsumer.accept((MissingObjectView)snapshot);
        }
        if (snapshot instanceof BlobView && this.blobConsumer != null) {
            this.blobConsumer.accept((BlobView)snapshot);
        }
        if (snapshot instanceof ManifestRefView && this.manifestConsumer != null) {
            this.manifestConsumer.accept((ManifestRefView)snapshot);
        }
        if (snapshot instanceof SkippedElementView && this.skippedConsumer != null) {
            this.skippedConsumer.accept((SkippedElementView)snapshot);
        }
        if (snapshot instanceof TreeView && this.treeConsumer != null) {
            visitChildren = this.treeConsumer.apply((TreeView)snapshot);
        }
        return visitChildren;
    }

    public static class Builder {
        private final TreeVisitor result = new TreeVisitor();

        public Builder onBlob(Consumer<BlobView> blob) {
            this.result.blobConsumer = blob;
            return this;
        }

        public Builder onDamaged(Consumer<DamagedObjectView> damaged) {
            this.result.damagedConsumer = damaged;
            return this;
        }

        public Builder onManifestRef(Consumer<ManifestRefView> mf) {
            this.result.manifestConsumer = mf;
            return this;
        }

        public Builder onMissing(Consumer<MissingObjectView> missing) {
            this.result.missingConsumer = missing;
            return this;
        }

        public Builder onSkipped(Consumer<SkippedElementView> skipped) {
            this.result.skippedConsumer = skipped;
            return this;
        }

        public Builder onTree(Function<TreeView, Boolean> tree) {
            this.result.treeConsumer = tree;
            return this;
        }

        public TreeVisitor build() {
            return this.result;
        }
    }
}

