/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.BHiveExecution;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.op.ClearObjectMarkersOperation;
import io.bdeploy.bhive.op.CreateObjectMarkersOperation;
import io.bdeploy.bhive.op.InsertExistingObjectsOperation;
import io.bdeploy.bhive.op.InsertManifestOperation;
import io.bdeploy.bhive.op.ManifestConsistencyCheckOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ManifestRefScanOperation;
import io.bdeploy.bhive.op.ObjectListOperation;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class CopyOperation
extends BHive.Operation<Void> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_SIZE)
    private final SortedSet<ObjectId> objects = new TreeSet<ObjectId>();
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    @AuditParameterExtractor.NoAudit
    private BHiveExecution destinationHive;
    private boolean partialAllowed;

    @Override
    public Void call() throws Exception {
        RuntimeAssert.assertNotNull(this.destinationHive, "Destination Hive not set");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Copying objects...");){
            if (this.objects.isEmpty() && this.manifests.isEmpty()) {
                this.execute(new ManifestListOperation()).forEach(this.manifests::add);
                this.execute(new ObjectListOperation()).forEach(this.objects::add);
            }
            String markerUuid = this.destinationHive.execute(new CreateObjectMarkersOperation().setObjectIds(this.objects));
            TreeSet additional = new TreeSet();
            this.manifests.forEach(m3 -> additional.addAll(this.execute(new ManifestRefScanOperation().setAllowMissingObjects(true).setManifest((Manifest.Key)m3)).values()));
            this.manifests.addAll(additional);
            if (!this.objects.isEmpty()) {
                InsertExistingObjectsOperation destinationInsert = new InsertExistingObjectsOperation().setSourceObjectManager(this.getObjectManager());
                this.objects.forEach(destinationInsert::addObject);
                this.destinationHive.execute(destinationInsert);
            }
            if (!this.manifests.isEmpty()) {
                List<Manifest> loaded = this.manifests.stream().map(this.getManifestDatabase()::getManifest).collect(Collectors.toList());
                InsertManifestOperation destinationManifestInsert = new InsertManifestOperation();
                loaded.forEach(destinationManifestInsert::addManifest);
                this.destinationHive.execute(destinationManifestInsert);
                if (!this.partialAllowed) {
                    ManifestConsistencyCheckOperation destinationCheck = new ManifestConsistencyCheckOperation().setDryRun(false);
                    this.manifests.forEach(destinationCheck::addRoot);
                    this.destinationHive.execute(destinationCheck);
                }
            }
            this.destinationHive.execute(new ClearObjectMarkersOperation().setMarkersUuuid(markerUuid));
        }
        return null;
    }

    public CopyOperation addObject(ObjectId object) {
        this.objects.add(object);
        return this;
    }

    public CopyOperation addManifest(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public CopyOperation setPartialAllowed(boolean allowed) {
        this.partialAllowed = allowed;
        return this;
    }

    public CopyOperation setDestinationHive(BHiveExecution hive) {
        this.destinationHive = hive;
        return this;
    }
}

