/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.ObjectId;
import io.bdeploy.bhive.objects.MarkerDatabase;
import io.bdeploy.common.util.RuntimeAssert;
import io.bdeploy.common.util.UuidHelper;
import java.util.SortedSet;

public class CreateObjectMarkersOperation
extends BHive.Operation<String> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private SortedSet<ObjectId> ids;

    @Override
    public String call() throws Exception {
        String markerUuid = UuidHelper.randomId();
        RuntimeAssert.assertNotNull(this.ids, "no ids to protect set");
        if (this.ids.isEmpty()) {
            return null;
        }
        MarkerDatabase.waitRootLock(this.getMarkerRoot());
        MarkerDatabase mdb = new MarkerDatabase(this.getMarkerRoot().resolve(markerUuid), this.getActivityReporter());
        this.ids.forEach(mdb::addMarker);
        return markerUuid;
    }

    public CreateObjectMarkersOperation setObjectIds(SortedSet<ObjectId> objects) {
        this.ids = objects;
        return this;
    }
}

