/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.ReadOnlyOperation;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.ReferenceHandler;
import io.bdeploy.common.ActivityReporter;
import io.bdeploy.common.util.RuntimeAssert;
import java.nio.file.Path;
import java.util.SortedSet;

@ReadOnlyOperation
public class ExportOperation
extends BHive.Operation<Manifest.Key> {
    private Manifest.Key manifest;
    private Path target;
    private ReferenceHandler refHandler;

    @Override
    public Manifest.Key call() throws Exception {
        RuntimeAssert.assertNotNull(this.manifest, "Manifest not set");
        RuntimeAssert.assertNotNull(this.target, "Target path not set");
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Pushing manifests...", -1L);){
            SortedSet<Manifest.Key> keys = this.getManifestDatabase().getAllForName(this.manifest.getName());
            if (!keys.contains(this.manifest)) {
                throw new IllegalArgumentException("Manifest not found: " + this.manifest);
            }
            Manifest mf = this.getManifestDatabase().getManifest(this.manifest);
            this.getObjectManager().exportTree(mf.getRoot(), this.target, this.refHandler);
            Manifest.Key key = this.manifest;
            return key;
        }
    }

    public ExportOperation setManifest(Manifest.Key manifest) {
        this.manifest = manifest;
        return this;
    }

    public ExportOperation setTarget(Path target) {
        this.target = target;
        return this;
    }

    public ExportOperation setReferenceHandler(ReferenceHandler handler) {
        this.refHandler = handler;
        return this;
    }
}

