/*
 * Decompiled with CFR 0.152.
 */
package io.bdeploy.bhive.op;

import io.bdeploy.bhive.BHive;
import io.bdeploy.bhive.audit.AuditParameterExtractor;
import io.bdeploy.bhive.model.Manifest;
import io.bdeploy.bhive.objects.view.ElementView;
import io.bdeploy.bhive.op.ManifestConsistencyCheckOperation;
import io.bdeploy.bhive.op.ManifestListOperation;
import io.bdeploy.bhive.op.ObjectConsistencyCheckOperation;
import io.bdeploy.common.ActivityReporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class FsckOperation
extends BHive.Operation<List<ElementView>> {
    @AuditParameterExtractor.AuditWith(value=AuditParameterExtractor.AuditStrategy.COLLECTION_PEEK)
    private final SortedSet<Manifest.Key> manifests = new TreeSet<Manifest.Key>();
    private boolean repair;

    @Override
    public List<ElementView> call() throws Exception {
        try (ActivityReporter.Activity activity = this.getActivityReporter().start("Checking manifests...", -1L);){
            if (this.manifests.isEmpty()) {
                SortedSet<Manifest.Key> localManifests = this.execute(new ManifestListOperation());
                this.manifests.addAll(localManifests);
            }
            ManifestConsistencyCheckOperation mfCheck = new ManifestConsistencyCheckOperation().setDryRun(!this.repair);
            ObjectConsistencyCheckOperation objCheck = new ObjectConsistencyCheckOperation().setDryRun(!this.repair);
            this.manifests.forEach(k -> {
                mfCheck.addRoot((Manifest.Key)k);
                objCheck.addRoot((Manifest.Key)k);
            });
            ArrayList<ElementView> problematic = new ArrayList<ElementView>();
            problematic.addAll((Collection)this.execute(mfCheck));
            problematic.addAll((Collection)this.execute(objCheck));
            ArrayList<ElementView> arrayList = problematic;
            return arrayList;
        }
    }

    public FsckOperation addManifest(Manifest.Key key) {
        this.manifests.add(key);
        return this;
    }

    public FsckOperation setRepair(boolean repair) {
        this.repair = repair;
        return this;
    }
}

